% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LocalizationStatistics.R
\name{localizationStatistics}
\alias{localizationStatistics}
\title{Localization Distances Statistics}
\usage{
localizationStatistics(y, robustify = TRUE, whiskerrule)
}
\arguments{
\item{y}{matrix p by n, being n the number of functions and p the number of grid points.}

\item{robustify}{if TRUE the mean and standard deviation are estimated with a the trimmed sample. Default is TRUE.}

\item{whiskerrule}{Range parameter for the univariate boxplot detection rule. Default = 3.}
}
\value{
a list with the localization distances of each function (localizationDistances),
the estimated mean (mean) and standard deviation (sd).
}
\description{
Estimate the mean and standard deviation of the localization distances mean.
}
\examples{
localizationStatistics_full <- localizationStatistics(exampleData[,1:101], robustify = TRUE)
localizationStatistics_full$trim_mean[c(1, 25, 50 ,75, 100)]
localizationStatistics_full$trim_sd[c(1, 25, 50 ,75, 100)]

}
\references{
Elías, Antonio, Jiménez, Raúl and Yukich, Joe (2020). Localization processes for functional data analysis (submitted).
}
