% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/heatmap_lipidome_from_limma.R
\name{heatmap_lipidome_from_limma}
\alias{heatmap_lipidome_from_limma}
\title{Create 'lipidomeR' heatmaps of model statistics}
\usage{
heatmap_lipidome_from_limma(
  x,
  names.mapping = NULL,
  axis.x.carbons = TRUE,
  baseline.adjusted = FALSE,
  class.facet = "row",
  class.subset = NULL,
  F.test = FALSE,
  omit.class = NULL,
  omit.factor = NULL,
  order.factor = FALSE,
  p.val.thresholds = c(0.01, 0.05, 0.1),
  p.val.labels = c(8, 4, 3),
  p.val.label.bg.size = 2,
  p.val.label.size = 1,
  p.adj.method = "BH",
  plot.individual = FALSE,
  plot.all = TRUE,
  print.figure = TRUE,
  print.formula = TRUE,
  formula.width = 110,
  legend.key.size.multiplier = 2,
  range.min.N.carbons = 5,
  range.min.N.double.bonds = 5,
  scales = "fixed",
  shadowtext = FALSE,
  space = "free",
  survival = FALSE,
  verbose = FALSE,
  wrap.contrast.name = TRUE
)
}
\arguments{
\item{x}{(Required) list of output from
the \code{\link{compute_models_with_limma}} function or related functions.}

\item{names.mapping}{(Optional) mapping of lipid names from
the \code{\link{map_lipid_names}} function.}

\item{axis.x.carbons}{(Optional) \code{TRUE} or \code{FALSE}: Should
the lipid size (i.e., number of carbon atoms in the fatty acid chain) be
presented on the x-axis or y-axis?}

\item{baseline.adjusted}{\code{TRUE} or \code{FALSE}: Is the model object
that is specified as argument \code{x} a baseline-adjusted regression
model? (Note: this model type is not yet provided in the package.)}

\item{class.facet}{(Optional) character string with possible values
\code{'col'}, \code{'row'} or \code{'wrap'}:
Present lipid classes as panels organized into columns, rows or into a
wrapped layout spanning over multiple rows and columns. The alternative
\code{'wrap'} is only available with \code{plot.infividual = TRUE}.}

\item{class.subset}{(Optional) character vector specifying a subset of
the lipid classes (e.g., \code{c( 'PC', 'SM', 'TG' )}). Same outcome
can be achieved with the argument \code{omit.class}.}

\item{F.test}{(Optional) \code{TRUE} or \code{FALSE}: Should the result of
an F-test be visualized instead of individual model coefficients?
Result from the function \code{\link{compute_F_test_with_limma}} needs
to be provided as argument \code{x} for the
\code{\link{heatmap_lipidome_from_limma}} function along with
the argument \code{F.test = TRUE}.}

\item{omit.class}{(Optional) character vector of lipid classes omitted from
the visualization (e.g., \code{c( 'PC', 'SM', 'TG' )}).}

\item{omit.factor}{(Optional) character vector of lipid classes omitted from
the visualization (e.g., \code{c( 'Time' )}).}

\item{order.factor}{(Optional) \code{TRUE} or \code{FALSE}: Sort the factor
panels alphabetically?}

\item{p.val.thresholds}{(Optional) numeric vector with increasing values of
highlighting thresholds for multiple-testing-corrected p-values.
For instance, \code{c( 0.01, 0.05, 0.1 )} gives distinct highlighting of
associations in the ranges \eqn{p < 0.01}, \eqn{0.01 \geq p < 0.05}, and
\eqn{0.05 \geq p < 0.1}. If the number of these categories is changed from
the default value, also the argument \code{p.val.labels} needs to be
modified to match it.}

\item{p.val.labels}{(Optional) numeric vector of point characters for the
p-value highlighting categories specified in the argument
\code{p.val.thresholds}. The values need to be compatible with
the function \code{\link[ggplot2]{scale_shape_manual}}.
If the number of these labels is changed from the default value, also
the argument \code{p.val.thresholds} needs to be modified to match it.}

\item{p.val.label.bg.size}{(Optional) numeric value to scale the size of
the colored background of the symbols that indicate values with
statistical significance. The background is used to ensure that
the white symbols are visible also when the color of a heatmap
rectangle is of a bleak color.}

\item{p.val.label.size}{(Optional) numeric value to scale the size of the
symbols that indicate values with statistical significance.}

\item{p.adj.method}{(Optional) name of the method to correct p-values for
multiple testing. Accepted values are as in the function
\code{stats::p.adjust()}.}

\item{plot.individual}{(Optional) \code{TRUE} or \code{FALSE}: Create
specific figures for each coefficient of the model? For models with many
independent variables, this may take some time to complete.}

\item{plot.all}{(Optional) \code{TRUE} or \code{FALSE}: Create
a combined figure of all the coefficients of the model? For models with
many independent variables, this may lead to too busy a figure.}

\item{print.figure}{(Optional) \code{TRUE} or \code{FALSE}: Print created
figure(s) to the standard output? Note that when
\code{plot.individual = TRUE}, multiple figures will be printed
consecutively.}

\item{print.formula}{(Optional) \code{TRUE} or \code{FALSE}: Add
the model formula as a title to the figure? We recommend to use
\code{print.formula = TRUE} to make the result more understandable and
reproducible.}

\item{formula.width}{(Optional) numeric value to specify the width of a line
in the model formula. Relevant only if \code{print.formula = TRUE}.}

\item{legend.key.size.multiplier}{(Optional) numeric value to scale the size
of the figure (key) legends.}

\item{range.min.N.carbons}{(Optional) numeric value to specify the minimum
range of the axis showing the lipid size (number of carbon atoms in the
fatty acid chains). This value can be increased from the default value to
improve readability in situations, where there are lipid classes with
little or no variation in the lipid size.}

\item{range.min.N.double.bonds}{(Optional) numeric value to specify
the minimum range of the axis showing the lipid saturation (number of
double bonds in the fatty acid chains). This value can be increased from
the default value to improve readability in situtions, where there are
lipid classes with little or no variation in the lipid saturation.}

\item{scales}{(Optional) character string with possible values
\code{'fixed'}, \code{'free'}, \code{'free_x'} or \code{'free_y'}. This
argument specifies, whether the axes in multiple sub-heatmaps will be in
the same scale (\code{'fixed'}) or in a scale specific to each sub-figure.
See the function \code{\link[ggplot2]{facet_grid}} for details.}

\item{shadowtext}{(Optional) \code{TRUE} or \code{FALSE}: Should an
alternative method of statistical significance highlighting be used in
the figure? If \code{TRUE}, highlighting will be based on the function
\code{\link[shadowtext]{geom_shadowtext}}.}

\item{space}{(Optional) character string with possible values
\code{'fixed'}, \code{'free'}, \code{'free_x'} or \code{'free_y'}.
This argument specifies, whether the sub-heatmaps will be of identical
size (\code{'fixed'}) or not.
See the function \code{\link[ggplot2]{facet_grid}} for details.}

\item{survival}{(Optional) \code{TRUE} or \code{FALSE}: Is the model object
that is specified as argument \code{x} a survival model?
(Note: this model type is not yet provided in the package.)}

\item{verbose}{(Optional) \code{TRUE} or \code{FALSE}: Print information
about the progress of the function call?}

\item{wrap.contrast.name}{(Optional) \code{TRUE} or \code{FALSE}: Wrap
the name of a contrast to multiple lines to ensure readability?}
}
\value{
List of 'lipidomeR' heatmap figure(s).
}
\description{
Use this function to creating heatmaps of model statistics from
   the output of the \code{\link{compute_models_with_limma}} function or
   related functions (\code{\link{compute_F_test_with_limma}} and
   \code{\link{compute_post_hoc_test_with_limma}}).
}
\seealso{
\code{\link{compute_models_with_limma}} for computing the argument
   \code{x} for this function.
}
