% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{fitWindow}
\alias{fitWindow}
\title{Adjust the visible window such that it fits all items}
\usage{
fitWindow(id, options)
}
\arguments{
\item{id}{graph2d id or a \code{linevis} object (the output from \code{linevis()})}

\item{options}{Named list of options controlling the animation. Most common
option is \code{"animation" = TRUE/FALSE}. For a full list of options, see
the "fit" method in the
\href{https://visjs.github.io/vis-timeline/docs/graph2d/#Methods}{official
graph2d documentation}}
}
\value{
None, side-effect is Javascript call
}
\description{
Adjust the visible window such that it fits all items
}
\examples{
if (interactive()) {
library(shiny)
shinyApp(
  ui = fluidPage(
    linevisOutput("graph2d"),
    actionButton("btn", "Fit all items")
  ),
  server = function(input, output) {
    output$graph2d <- renderLinevis(
      linevis(data.frame(
        start = c(Sys.Date(), Sys.Date() - 1), content = c("1", "2")
      ))
    )
    observeEvent(input$btn, {
      fitWindow("graph2d", list(animation = FALSE))
    })
  }
)
}
}
