% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sample.R
\name{plot_sample}
\alias{plot_sample}
\title{Plot the distances for a given sample}
\usage{
plot_sample(
  d,
  sample,
  dimension = c("row", "column"),
  get_min = TRUE,
  add_labels = TRUE,
  ...
)
}
\arguments{
\item{d}{A distance or similarity matrix}

\item{sample}{Sample ID (in row or column names)}

\item{dimension}{Whether to look at the row or column}

\item{get_min}{If TRUE, get the minimum (for a distance matrix);
if FALSE, get the maximum (for a similarity matrix)}

\item{add_labels}{If TRUE, label the individual sample and the optimal sample}

\item{...}{Passed to \code{points()}}
}
\value{
None.
}
\description{
Plot the distances for a given sample, highlighting itself and the closest sample
}
\examples{
# align rows in the provided dataset, lineup2ex
aligned <- align_matrix_rows(lineup2ex$gastroc, lineup2ex$islet)
# find correlated columns
selected_genes <- (corr_betw_matrices(aligned[[1]], aligned[[2]], "paired") > 0.75)
# calculate correlation between rows
similarity <- corr_betw_matrices(t(lineup2ex$gastroc[,selected_genes]),
                                 t(lineup2ex$islet[,selected_genes]), "all")

plot_sample(similarity, "Mouse3659", get_min=FALSE)
plot_sample(similarity, "Mouse3655", "column", get_min=FALSE)

}
