% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contrastTest.R
\name{contrastTest}
\alias{contrastTest}
\title{Test Contrasts}
\usage{
contrastTest(
  estVec,
  n,
  dfModel,
  dfError,
  mse,
  C = NULL,
  test = c("scheffe", "bonferroni", "hsd", "lsd"),
  ...
)
}
\arguments{
\item{estVec}{numeric vector of parameter estimates for comparison}

\item{n}{numeric vector indicating the sample size for the parameter estimates, if a single value is given it is assumed to apply to all estiamtes}

\item{dfModel}{numeric value for the model degrees of freedom}

\item{dfError}{numeric value for the error or residual degrees of freedom}

\item{mse}{numeric value for the mean squared error from the model}

\item{C}{numeric matrix, each row is a contrast that should sum to zero, see details}

\item{test}{character, indicating which testing method should be used, see details}

\item{...}{currently ignored}
}
\value{
Object of class anova and data.frame
}
\description{
Contrast testing function. Designed to test contrasts of parameter estimates from a linear model.
}
\details{
The test argument can be one of the following: 'scheffe','bonferroni','hsd', or 'lsd'. 'hsd' is the Tukey HSD test. 'lsd' is th Fisher LSD test. The other two are the Scheffe test and Bonferroni adjustment.

The matrix C is the contrast matrix. Each row is a separate contrast. The number of columns of C must be equal to the \code{length(estVec)}. Row names for C are retained in the output, but they are not required.
}
\examples{
data(genericData)

mod <- lm(Y~A,data=genericData)
dfModel <- anovaTable(mod)['Model','df']
dfError <- anovaTable(mod)['Residual','df']
mse <- anovaTable(mod)['Residual','MS']
meanVec <- aggregate(Y~A,FUN=mean,data=genericData)$Y
n <- aggregate(Y~A,FUN=length,data=genericData)$Y

## can add names for ease of interpretation with the output
names(meanVec) <- c('group 1','group 2','group 3')
contrastTest(estVec=meanVec,n=n,dfModel=dfModel,dfError=dfError,mse=mse,test='hsd')

## each group vs the mean of the other two
C <- rbind(c(1,-0.5,-0.5),c(-0.5,1,-0.5),c(-0.5,-0.5,1))
## row names are not required but are helpful
row.names(C) <- c('1 vs 2+3','2 vs 1+3','3 vs 1+2')
contrastTest(estVec=meanVec,n=n,dfModel=dfModel,dfError=dfError,mse=mse,C=C,test='scheffe')

}
