% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-fisherian.R
\name{evidence}
\alias{evidence}
\title{Likelihood-Based Evidence}
\usage{
evidence(model, data, theta1, theta2, ...)
}
\arguments{
\item{model}{The likelihood model}

\item{data}{Data frame for likelihood computation}

\item{theta1}{First parameter value}

\item{theta2}{Second parameter value}

\item{...}{Additional arguments passed to loglik}
}
\value{
Evidence value (log likelihood ratio)
}
\description{
Computes the strength of evidence for theta1 vs theta2:
E(theta1, theta2) = logL(theta1) - logL(theta2)
}
\details{
Positive values favor theta1, negative values favor theta2.

Conventional interpretation (following Royall):
\itemize{
\item |E| > log(8) ~ 2.08: Strong evidence
\item |E| > log(32) ~ 3.47: Very strong evidence
}
}
