# lightsf - Collection of georeferenced and spatial datasets from different domains
# Version 0.1.0
# Copyright (C) 2025 Ingrid Romero Pinilla
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# auckland_poly


library(testthat)

# Test 1: Confirm the object is a data.frame
test_that("auckland_poly is a data.frame", {
  expect_s3_class(auckland_poly, "data.frame")
})

# Test 2: Confirm it has exactly 4 columns
test_that("auckland_poly has 4 columns", {
  expect_equal(length(auckland_poly), 4)
})

# Test 3: Confirm it has exactly 167 rows
test_that("auckland_poly has 167 rows", {
  expect_equal(nrow(auckland_poly), 167)
})

# Test 4: Confirm column names are correct
test_that("auckland_poly has correct column names", {
  expect_named(auckland_poly, c("Easting", "Northing", "Deaths.1977.85", "Under.5.1981"))
})

# Test 5: Confirm column types are as expected
test_that("auckland_poly columns have correct types", {
  expect_type(auckland_poly$Easting, "double")
  expect_type(auckland_poly$Northing, "double")
  expect_type(auckland_poly$Deaths.1977.85, "double")
  expect_type(auckland_poly$Under.5.1981, "double")
})
