% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/state.R
\name{lx_state}
\alias{lx_state}
\title{set light state (lifx API endpoint PUT set state)}
\usage{
lx_state(
  power = NULL,
  color_name = NULL,
  brightness = NULL,
  infrared = NULL,
  duration = 0,
  fast = FALSE,
  selector = "all",
  token = lx_get_token()
)
}
\arguments{
\item{power}{string - if set to "on", turns the light on, if set to "off" turns it off.}

\item{color_name}{a color name (i.e. "red"), hexadecimal color code (i.e. "#FF0000") or output from lx_color() (in 'LIFX' api format (see \url{https://api.developer.lifx.com/docs/colors}). If this parameter is used, other parameters may be ignored.}

\item{brightness}{set the brightness (0-1)}

\item{infrared}{infrared brightness (0-1)}

\item{duration}{in seconds, how long to perform the transition}

\item{fast}{Executes the query fast, without initial state checks and wait for no results. See \url{https://api.developer.lifx.com/docs/set-state}}

\item{selector}{'LIFX' api "selector" such as "all", "id:12345", or "location:kitchen". Can be created with \code{\link{lx_selector}} or written manually (see \url{https://api.developer.lifx.com/docs/selectors}}

\item{token}{API token (see ?lx_save_token). If left empty, the token is retrieved from the environmental variable if available. (see \code{\link{lx_save_token}})}
}
\value{
an 'httr' response object (see \code{\link[httr]{response}})
}
\description{
set light state (lifx API endpoint PUT set state)
}
\references{
\url{https://api.developer.lifx.com/docs/set-state}
}
