# leastcostpath - version 2.0.13 <img src="https://josephlewis.github.io/leastcostpath.png" align="right"  width="20%" height="20%"/>

<b>leastcostpath</b> from version 2.0.0 onwards is built without dependency on the R package gdistance and instead relies on <b>sf</b> and <b>terra</b>.

**Since 2.0.8 leastcostpath can use both projected and geographic coordinate systems**

*Functions currently in development:*

*Functions recently added:*

Getting Started
---------------

Installation
--------

    #install.packages("devtools")
    library(devtools)
    install_github("josephlewis/leastcostpath")
    library(leastcostpath)
    
Issues
--------

Please submit issues and enhancement requests via github Issues
  * If submitting an issue, please clearly describe the issue, including steps to reproduce when it is a bug, or a justification for the proposed enhancement request


Case Studies Using _leastcostpath_
--------

**Lewis**, J. (2023). Explaining Known Past Routes, Underdetermination, and the Use of Multiple Cost Functions. Journal of Archaeological Method and Theory. https://doi.org/10.1007/s10816-023-09621-w

Martin, S. A., Peterman, W. E., Lipps, G. J., & Gibbs, H. L. (2023). Inferring population connectivity in eastern massasauga rattlesnakes (Sistrurus catenatus) using landscape genetics. Ecological Applications, 33(2). https://doi.org/10.1002/eap.2793

Fabrício Machado, A., Miranda, F.R., 2022. The potential distribution of Cyclopes didactylus , a silky anteater, reveals a likely unknown population and urgent need for forest conservation in Northeast Brazil. J. Trop. Ecol. 38, 454–461. https://doi.org/10.1017/S0266467422000372

Theron, K.J., J.S. Pryke and M.J. Samways 2022. Maintaining functional connectivity in grassland corridors between plantation forests promotes high-quality habitat and conserves range restricted grasshoppers. Landsc Ecol 37, 2081–97

Barnett, T., J. Valdez-Tullett and L.M. Bjerketvedt 2022. Close encounters: visibility and accessibility of Atlantic rock art in Scotland. Abstractions Based on Circles: Papers on prehistoric rock art presented to Stan Beckensall on his 90th birthday, 63

Fjellström, M., Seitsonen, O., Wallén, H., 2022. Mobility in Early Reindeer Herding, in: Salmi, A.-K. (Ed.), Domestication in Action, Arctic Encounters. Springer International Publishing, Cham, pp. 187–212. https://doi.org/10.1007/978-3-030-98643-8_7

Field, S., Glowacki, D.M., Gettler, L.T., 2022. The Importance of Energetics in Archaeological Least Cost Analysis. J Archaeol Method Theory. https://doi.org/10.1007/s10816-022-09564-8

**Lewis**, J., 2021. Probabilistic Modelling for Incorporating Uncertainty in Least Cost Path Results: a Postdictive Roman Road Case Study. Journal of Archaeological Method and Theory. https://doi.org/10.1007/s10816-021-09522-w

Ludwig, B., 2020. Reconstructing the Ancient Route Network in Pergamon’s Surroundings. Land 9, 241. https://doi.org/10.3390/land9080241

Versioning
----------

See NEWS.md for a summary of Version updates

Authors
-------

-   Joseph Lewis - *author / creator* - [Website](https://josephlewis.github.io)

Citation
--------

Please cite as:

    Lewis, J. (2023) leastcostpath: Modelling Pathways and Movement Potential Within a Landscape. 
    Available at: https://github.com/josephlewis/leastcostpath
