% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contextmenu.R
\name{showContextmenu}
\alias{showContextmenu}
\title{showContextmenu}
\usage{
showContextmenu(map, lat = NULL, lng = NULL, data = leaflet::getMapData(map))
}
\arguments{
\item{map}{a map widget object created from \code{\link[leaflet]{leaflet}()}}

\item{lat}{a vector of latitudes or a formula (similar to the \code{lng}
argument; the names \code{lat} and \code{latitude} are used when guessing
the latitude column from \code{data})}

\item{lng}{a numeric vector of longitudes, or a one-sided formula of the form
\code{~x} where \code{x} is a variable in \code{data}; by default (if not
explicitly provided), it will be automatically inferred from \code{data} by
looking for a column named \code{lng}, \code{long}, or \code{longitude}
(case-insensitively)}

\item{data}{the data object from which the argument values are derived; by
default, it is the \code{data} object provided to \code{leaflet()}
initially, but can be overridden}
}
\value{
A leaflet map object
}
\description{
Open the contextmenu at certain lat/lng-coordinates
}
\seealso{
Other Contextmenu Functions: 
\code{\link{addContextmenu}()},
\code{\link{addItemContextmenu}()},
\code{\link{context_mapmenuItems}()},
\code{\link{context_markermenuItems}()},
\code{\link{context_menuItem}()},
\code{\link{disableContextmenu}()},
\code{\link{enableContextmenu}()},
\code{\link{hideContextmenu}()},
\code{\link{insertItemContextmenu}()},
\code{\link{mapmenuItems}()},
\code{\link{markermenuItems}()},
\code{\link{menuItem}()},
\code{\link{removeItemContextmenu}()},
\code{\link{removeallItemsContextmenu}()},
\code{\link{setDisabledContextmenu}()}
}
\concept{Contextmenu Functions}
