% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/openweather.R
\name{openweatherCurrentOptions}
\alias{openweatherCurrentOptions}
\title{openweatherCurrentOptions}
\usage{
openweatherCurrentOptions(
  lang = "en",
  minZoom = 7,
  interval = 10,
  imageLoadingUrl = paste0(openweatherDependency()[[1]]$name, "-",
    openweatherDependency()[[1]]$version, "/owmloading.gif"),
  ...
)
}
\arguments{
\item{lang}{'en', 'de', 'ru', 'fr', 'es', 'ca'. Language of popup texts.
Note: not every translation is finished yet.}

\item{minZoom}{Number (7). Minimal zoom level for fetching city data. Use
smaller values only at your own risk.}

\item{interval}{Number (10). Time in minutes to reload city data. Please do
not use less than 10 minutes.}

\item{imageLoadingUrl}{URL of the loading image.}

\item{...}{Further options passed to \code{L.OWM.current}. See the
\href{https://github.com/trafficonese/leaflet-openweathermap#options}{full
list of options}}
}
\value{
A list of options for \code{addOpenweatherCurrent}
}
\description{
openweatherCurrentOptions
}
\seealso{
Other Openweathermap Functions: 
\code{\link{addOpenweatherCurrent}()},
\code{\link{addOpenweatherTiles}()},
\code{\link{openweatherOptions}()}
}
\concept{Openweathermap Functions}
