% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/arrowhead.R
\name{arrowheadOptions}
\alias{arrowheadOptions}
\title{Arrowhead Options}
\usage{
arrowheadOptions(
  yawn = 60,
  size = "15\%",
  frequency = "allvertices",
  proportionalToTotal = FALSE,
  offsets = NULL,
  perArrowheadOptions = NULL,
  ...
)
}
\arguments{
\item{yawn}{Defines the width of the opening of the arrowhead, given in
degrees. The larger the angle, the wider the arrowhead.}

\item{size}{Determines the size of the arrowhead. Accepts three types of
  values:
  \itemize{
  \item A string with the suffix \code{'m'}, i.e. \code{'500m'} will set the
  size of the arrowhead to that number of meters.
  \item A string with the suffix \code{'\%'}, i.e. \code{'15\%'} will render
  arrows whose size is that percentage of the size of the parent polyline. If
  the polyline has multiple segments, it will take the percent of the
  average size of the segments.
  \item A string the suffix \code{'px'}, i.e. \code{'20px'} will render an
  arrowhead whose size stays at a constant pixel value, regardless of zoom
  level. Will look strange at low zoom levels or for smaller parent vectors.
  Ideal for larger parent vectors and at higher zoom levels.
}}

\item{frequency}{How many arrowheads are rendered on a polyline.
\itemize{
\item \code{'allvertices'} renders an arrowhead on each vertex.
\item \code{'endonly'} renders only one at the end.
\item A numeric value renders that number of arrowheads evenly spaced
along the polyline.
\item A string with suffix \code{'m'}, i.e. \code{'100m'} will render
arrowheads spaced evenly along the polyline with roughly that many meters
between each one.
\item A string with suffix \code{'px'}, i.e. \code{'30px'} will render
arrowheads spaced evenly with roughly that many pixels between each,
regardless of zoom level. }}

\item{proportionalToTotal}{Only relevant when size is given as a percent.
Useful when frequency is set to \code{'endonly'}. Will render the
arrowheads with a size proportional to the entire length of the
multi-segmented polyline, rather than proportional to the average length of
all the segments.}

\item{offsets}{Enables the developer to have the arrowheads start or end at
some offset from the start and/or end of the polyline. This option can be a list
with `start` and `end` names. The values must be strings
defining the size of the offset in either meters or pixels, i.e.
\code{list('start' = '100m', 'end' = '15px')}.}

\item{perArrowheadOptions}{Enables the developer to customize arrowheads on a
one-by-one basis. Must be in the form of a function of i, which is the
index of the arrowhead as it is rendered in the loop through all
arrowheads. Must return an options object. Cannnot
account for \code{frequency} or \code{proportionalToTotal} from within the
\code{perArrowheadOptions} callback. See the example for details.}

\item{...}{Additional options for arrowheads, inherited from
\href{https://leafletjs.com/reference.html#path}{L.Path}}
}
\value{
A list of options for \code{addArrowhead} polylines
}
\description{
Additional list of options for polylines with arrowheads. You can also pass
options inherited from
\href{https://leafletjs.com/reference.html#path}{L.Path}
}
\references{
\url{https://github.com/slutske22/leaflet-arrowheads#options}
}
\seealso{
Other Arrowhead Functions: 
\code{\link{addArrowhead}()},
\code{\link{clearArrowhead}()},
\code{\link{removeArrowhead}()}
}
\concept{Arrowhead Functions}
