% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_marks.R
\name{predict_marks}
\alias{predict_marks}
\title{Predict values from the mark distribution}
\usage{
predict_marks(
  sim_realization,
  raster_list = NULL,
  scaled_rasters = FALSE,
  mark_model = NULL,
  xy_bounds = NULL,
  include_comp_inds = FALSE,
  competition_radius = 15,
  edge_correction = "none",
  seed = NULL
)
}
\arguments{
\item{sim_realization}{a data.frame containing a thinned or unthinned realization from
\code{simulate_mpp} (or \code{simulate_sc}). Must contain \code{x}, \code{y}, and \code{time}.}

\item{raster_list}{list of raster objects used for mark prediction.}

\item{scaled_rasters}{\code{TRUE} or \code{FALSE} indicating whether rasters are already scaled.}

\item{mark_model}{a mark model object. May be an \code{ldmppr_mark_model}, \code{model_fit}, or \code{workflow}.}

\item{xy_bounds}{vector of domain bounds as \code{c(a_x, b_x, a_y, b_y)}.}

\item{include_comp_inds}{\code{TRUE} or \code{FALSE} indicating whether to generate and use competition indices as covariates.}

\item{competition_radius}{positive numeric distance used when \code{include_comp_inds = TRUE}.}

\item{edge_correction}{type of edge correction to apply (\code{"none"} or \code{"toroidal"}).}

\item{seed}{optional nonnegative integer seed for reproducibility.}
}
\value{
a vector of predicted mark values.
}
\description{
Prefer using the S3 method \code{predict()} on an \code{ldmppr_mark_model}:
\code{predict(mark_model, sim_realization = ..., xy_bounds = ...)}.
This wrapper is retained for backward compatibility and is deprecated.
}
