% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mark_model_s3.R
\docType{class}
\name{ldmppr_mark_model}
\alias{ldmppr_mark_model}
\alias{print.ldmppr_mark_model}
\alias{summary.ldmppr_mark_model}
\alias{print.summary.ldmppr_mark_model}
\alias{predict.ldmppr_mark_model}
\alias{save_mark_model}
\alias{save_mark_model.ldmppr_mark_model}
\alias{load_mark_model}
\title{Mark model object}
\usage{
ldmppr_mark_model(
  engine,
  fit_engine = NULL,
  xgb_raw = NULL,
  recipe = NULL,
  outcome = "size",
  feature_names = NULL,
  rasters = NULL,
  info = list()
)

\method{print}{ldmppr_mark_model}(x, ...)

\method{summary}{ldmppr_mark_model}(object, ...)

\method{print}{summary.ldmppr_mark_model}(x, ...)

\method{predict}{ldmppr_mark_model}(
  object,
  new_data = NULL,
  sim_realization = NULL,
  raster_list = NULL,
  scaled_rasters = FALSE,
  xy_bounds = NULL,
  include_comp_inds = FALSE,
  competition_radius = 15,
  edge_correction = "none",
  seed = NULL,
  ...
)

save_mark_model(object, path, ...)

\method{save_mark_model}{ldmppr_mark_model}(object, path, ...)

load_mark_model(path)
}
\arguments{
\item{engine}{character string (currently \code{"xgboost"} and \code{"ranger"}).}

\item{fit_engine}{fitted engine object (e.g. \code{xgb.Booster} or a ranger fit).}

\item{xgb_raw}{raw xgboost payload (e.g. UBJ) used for rehydration.}

\item{recipe}{a prepped recipes object used for preprocessing new data.}

\item{outcome}{outcome column name (default \code{"size"}).}

\item{feature_names}{(optional) vector of predictor names required at prediction time.}

\item{rasters}{(optional) list of rasters used for prediction (e.g. for spatial covariates).}

\item{info}{(optional) list of metadata.}

\item{x}{an object of class \code{summary.ldmppr_mark_model}.}

\item{...}{passed to methods.}

\item{object}{a \code{ldmppr_mark_model} object.}

\item{new_data}{a data frame of predictors (and possibly outcome columns).
Ignored when \code{sim_realization} is supplied.}

\item{sim_realization}{optional simulation realization containing \code{x}, \code{y}, and \code{time}.
When supplied, predictors are built from rasters and optional competition indices.}

\item{raster_list}{optional list of rasters used when \code{sim_realization} is supplied.
If omitted, uses rasters stored in \code{object} when available.}

\item{scaled_rasters}{\code{TRUE} or \code{FALSE}; whether supplied rasters are pre-scaled.}

\item{xy_bounds}{domain bounds \code{c(a_x, b_x, a_y, b_y)} used for competition indices.}

\item{include_comp_inds}{\code{TRUE} or \code{FALSE}; include competition-index features.}

\item{competition_radius}{positive numeric distance used when \code{include_comp_inds = TRUE}.}

\item{edge_correction}{edge correction for competition indices (\code{"none"} or \code{"toroidal"}).}

\item{seed}{optional nonnegative integer seed.}

\item{path}{path to an \code{.rds} created by \code{\link{save_mark_model}} (or legacy objects).}
}
\value{
\describe{
   \item{\code{print()}}{prints a brief summary.}
   \item{\code{predict()}}{returns numeric predictions for new data.}
}

an object of class \code{"ldmppr_mark_model"}.
}
\description{
\code{ldmppr_mark_model} objects store a fitted mark model and preprocessing
information used to predict marks at new locations and times.
These objects are typically returned by \code{\link{train_mark_model}} and can be
saved/loaded with \code{\link{save_mark_model}} and \code{\link{load_mark_model}}.
}
\details{
The model may be backed by different engines (currently \code{"xgboost"} and
\code{"ranger"}). For \code{"xgboost"}, the object can store a serialized booster payload
to make saving/loading robust across R sessions.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(ldmppr_mark_model)}: Print a brief summary of the mark model.

\item \code{summary(ldmppr_mark_model)}: Summarize a mark model.

\item \code{predict(ldmppr_mark_model)}: Predict marks for new data.

\item \code{save_mark_model(ldmppr_mark_model)}: Save method for \code{ldmppr_mark_model}.

}}
\section{Functions}{
\itemize{
\item \code{ldmppr_mark_model()}: Create a mark model container.

\item \code{print(summary.ldmppr_mark_model)}: Print a summary produced by \code{\link{summary.ldmppr_mark_model}}.

\item \code{save_mark_model()}: Save a mark model to disk.

\item \code{load_mark_model()}: Load a saved mark model from disk.

}}
