% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldmppr_grids_S3.R
\docType{class}
\name{ldmppr_grids-class}
\alias{ldmppr_grids-class}
\alias{print.ldmppr_grids}
\alias{summary.ldmppr_grids}
\alias{print.summary.ldmppr_grids}
\alias{as.data.frame.ldmppr_grids}
\alias{length.ldmppr_grids}
\alias{[.ldmppr_grids}
\alias{as.list.ldmppr_grids}
\title{Grid schedule object}
\usage{
\method{print}{ldmppr_grids}(x, ...)

\method{summary}{ldmppr_grids}(object, ...)

\method{print}{summary.ldmppr_grids}(x, ...)

\method{as.data.frame}{ldmppr_grids}(x, ...)

\method{length}{ldmppr_grids}(x)

\method{[}{ldmppr_grids}(x, i, ...)

\method{as.list}{ldmppr_grids}(x, ...)
}
\arguments{
\item{x}{an object of class \code{ldmppr_grids}.}

\item{...}{unused.}

\item{object}{an object of class \code{ldmppr_grids}.}

\item{i}{indices of levels to keep.}
}
\value{
\describe{
  \item{\code{print()}}{prints a brief description of bounds and grid levels.}
  \item{\code{summary()}}{returns a \code{summary.ldmppr_grids}.}
  \item{\code{as.data.frame()}}{returns one row per level with dimensions and ranges.}
  \item{\code{length()}}{returns the number of levels.}
  \item{\code{[ ]}}{subsets levels, preserving class.}
  \item{\code{as.list()}}{returns the underlying list structure.}
}
}
\description{
Objects of class \code{ldmppr_grids} define one or more grid "levels" used by
\code{\link{estimate_process_parameters}}. Each level contains numeric vectors
\code{x}, \code{y}, and \code{t} defining the approximation grid. Levels are
typically ordered from coarse to fine.
}
\details{
A \code{ldmppr_grids} is a list with (at minimum):
\itemize{
  \item \code{levels}: list of levels; each level is a list with \code{x}, \code{y}, \code{t}
  \item \code{upper_bounds}: numeric \code{c(b_t, b_x, b_y)}
  \item \code{labels}: optional labels used only for printing
  \item \code{include_endpoints}: logical
}
}
\section{Functions}{
\itemize{
\item \code{print(ldmppr_grids)}: Print a brief summary of a grid schedule.

\item \code{summary(ldmppr_grids)}: Summarize a grid schedule.

\item \code{print(summary.ldmppr_grids)}: Print a summary produced by \code{summary.ldmppr_grids()}.

\item \code{as.data.frame(ldmppr_grids)}: Convert a grid schedule to a data.frame.

\item \code{length(ldmppr_grids)}: Number of levels in a grid schedule.

\item \code{[}: Subset grid levels.

\item \code{as.list(ldmppr_grids)}: Extract the underlying list representation.

}}
