% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldmppr_budgets.R
\name{ldmppr_budgets}
\alias{ldmppr_budgets}
\title{Create an optimization budget specification for estimate_process_parameters()}
\usage{
ldmppr_budgets(
  global_options = NULL,
  local_budget_first_level = NULL,
  local_budget_refinement_levels = NULL
)
}
\arguments{
\item{global_options}{(optional) list of NLopt options used for the global stage
(only relevant when \code{strategy} uses a global optimizer).
Examples: \code{list(maxeval = 2000, maxtime = 10)}.}

\item{local_budget_first_level}{(optional) list of NLopt options used for the local stage
at the first (coarsest) grid level.}

\item{local_budget_refinement_levels}{(optional) list of NLopt options used for local refinement
on subsequent (finer) grid levels in multi-resolution strategies. If \code{NULL}, the
estimator will fall back to \code{local_budget_first_level}.}
}
\value{
an object of class \code{"ldmppr_budgets"}.
}
\description{
\code{ldmppr_budgets()} defines per-stage optimization options (budgets) used by
\code{\link{estimate_process_parameters}} for NLopt via \code{\link[nloptr:nloptr]{nloptr}}.
}
\details{
The returned object is an S3 class. Use \code{summary()} and \code{as.data.frame()}
methods to inspect.
}
\examples{
b <- ldmppr_budgets(
  global_options = list(maxeval = 150),
  local_budget_first_level = list(maxeval = 300, xtol_rel = 1e-5),
  local_budget_refinement_levels = list(maxeval = 150, xtol_rel = 1e-5)
)
b
}
\seealso{
\code{\link{ldmppr_grids-class}} for methods and details.
}
