% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldmppr_budgets_S3.R
\docType{class}
\name{ldmppr_budgets-class}
\alias{ldmppr_budgets-class}
\alias{print.ldmppr_budgets}
\alias{summary.ldmppr_budgets}
\alias{print.summary.ldmppr_budgets}
\alias{as.data.frame.ldmppr_budgets}
\alias{length.ldmppr_budgets}
\alias{[.ldmppr_budgets}
\alias{as.list.ldmppr_budgets}
\title{Optimization budget specification object}
\usage{
\method{print}{ldmppr_budgets}(x, ...)

\method{summary}{ldmppr_budgets}(object, ...)

\method{print}{summary.ldmppr_budgets}(x, ...)

\method{as.data.frame}{ldmppr_budgets}(x, ...)

\method{length}{ldmppr_budgets}(x)

\method{[}{ldmppr_budgets}(x, i, ...)

\method{as.list}{ldmppr_budgets}(x, ...)
}
\arguments{
\item{x}{an object of class \code{ldmppr_budgets}.}

\item{...}{unused.}

\item{object}{an object of class \code{ldmppr_budgets}.}

\item{i}{indices of local stages to keep: 1 = first level, 2 = refinement levels.}
}
\value{
\describe{
  \item{\code{print()}}{prints a brief description of configured budgets.}
  \item{\code{summary()}}{returns a \code{summary.ldmppr_budgets}.}
  \item{\code{as.data.frame()}}{a compact table of the global/local budget entries (when present).}
  \item{\code{length()}}{number of available local budget stages (1 or 2).}
  \item{\code{[ ]}}{subset local budget stages (keeps global options).}
  \item{\code{as.list()}}{returns the underlying list structure.}
}
}
\description{
Objects of class \code{ldmppr_budgets} define optimizer budget/options used by
\code{\link{estimate_process_parameters}}.
}
\details{
A \code{ldmppr_budgets} is a list with (at minimum):
\itemize{
  \item \code{global_options}: list of NLopt options for the global stage (e.g., \code{maxeval}, \code{maxtime}).
  \item \code{local_budget_first_level}: list of NLopt options for the local stage at the first/coarsest grid level.
  \item \code{local_budget_refinement_levels}: optional list of NLopt options for local refinement levels
    (used only when \code{estimate_process_parameters(strategy = "multires_global_local")}).
}
}
\section{Functions}{
\itemize{
\item \code{print(ldmppr_budgets)}: Print a brief summary of optimization budgets.

\item \code{summary(ldmppr_budgets)}: Summarize an optimization budget specification.

\item \code{print(summary.ldmppr_budgets)}: Print a summary produced by \code{summary.ldmppr_budgets()}.

\item \code{as.data.frame(ldmppr_budgets)}: Convert budgets to a data.frame.

\item \code{length(ldmppr_budgets)}: Number of available local budget stages.

\item \code{[}: Subset local budget stages (keeps global options).

\item \code{as.list(ldmppr_budgets)}: Extract the underlying list representation.

}}
