% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_exhaustive.R
\name{.check_subspaces_for_group_size_setup}
\alias{.check_subspaces_for_group_size_setup}
\title{Searches over all possible subspaces for specified group size setup.}
\usage{
.check_subspaces_for_group_size_setup(
  best,
  grpsize_setup,
  sspace,
  condition,
  covariates,
  halting_test,
  thresh,
  print_info
)
}
\arguments{
\item{best}{The best matched groups so far together with its
p-value / thresh ratio; a list containing ratio and sets
(a list of subject index vectors).}

\item{grpsize_setup}{A set of group sizes as a data.table row (also a list).}

\item{sspace}{An ordered subject subspace: a list of vectors,
with one vector per group containing the corresponding subject indices.}

\item{condition}{A factor vector containing condition labels.}

\item{covariates}{A columnwise matrix containing
covariates to match the conditions on.}

\item{halting_test}{A function to apply to `covariates` (in matrix form)
which is TRUE iff the conditions are matched.
Signature: halting_test(condition, covariates, thresh).
The following halting tests are part of this package:
\code{\link{t_halt}}, \code{\link{U_halt}},
\code{\link{l_halt}}, \code{\link{ad_halt}},
\code{\link{ks_halt}}, \code{\link{wilks_halt}},
\code{\link{f_halt}}.
You can create the intersection of two or more halting
tests using \code{\link{create_halting_test}}.}

\item{thresh}{The return value of halting_test has to be greater than
or equal to thresh for the matched groups.}

\item{print_info}{If TRUE, prints summary information on the input and the
results, as well as progress information for the
exhaustive search and random algorithms. Default: TRUE;
can be changed using
\code{\link{set_param}("PRINT_INFO", FALSE)}.}
}
\value{
A list of logical vectors for the best matched groups.
}
\description{
Results are optimized for the following, in decreasing order of preference:
number of subjects; proportion of group sizes close to props;
p-value as large as possible.
}
\keyword{internal}
