% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.R
\name{summary.lcc}
\alias{summary.lcc}
\title{Summarize an \code{lcc} Object}
\usage{
\method{summary}{lcc}(object, type, adjustSigma, verbose, ...)
}
\arguments{
\item{object}{an object inheriting from class
\code{\link[lcc]{lcc}}, representing a fitted longitudinal
concordance correlation function.}

\item{type}{an optional character string specifying the type of
output to be returned. If \code{type="model"}, prints the summary
of the polynomial mixed-effects regression model. If
\code{type="lcc"}, prints the summary of the fitted and sampled
values for LCC, LPC, and LA as well as the concordance correlation
coefficient between fitted values from the model and observed
values as goodness of fit (gof) measurement. Defaults to
\code{type="model"}.}

\item{adjustSigma}{an optional logical value used when \code{type =
model}. If TRUE and the estimation method used to obtain object
was maximum likelihood, the residual standard error is multiplied
by \code{sqrt(nobs/(nobs - npar))}.  See
\code{\link[nlme]{summary.lme}} for more information.  Default is
TRUE.}

\item{verbose}{an optional logical value used to control the amount
of output in the \code{print.summary.lme} method when
\code{type = model} is used. Defaults to FALSE.}

\item{...}{not used.}
}
\value{
an object inheriting from class \code{summary.lcc}
  including: \item{fitted}{the fitted values extracted from the
  \code{lcc} object.} \item{gof}{the goodness of fit (gof) measurement
  is calculated using the concordance correlation coefficient between
  fitted and observed values. Value of 1 denote perfect concordance.}
  \item{AIC}{the Akaike Information Criterion corresponding to object.}
  \item{BIC}{the Bayesian Information Criterion corresponding to object.}
  \item{logLik}{If \code{REML=FALSE}, returns the log-likelihood value
  of the linear mixed-effects model; otherwise, the restricted
  log-likelihood is returned}
}
\description{
Additional information about the fit of longitudinal
  concordance correlation, longitudinal Pearson correlation, and
  longitudinal accuracy represented by an object of class
  \code{\link[lcc]{lcc}}. The returned object has a
  \code{\link[base]{print}} method.
}
\examples{

## Second degree polynomial model with random intercept, slope and
## quadratic term
fm1<-lcc(data = hue, subject = "Fruit", resp = "H_mean",
         method = "Method", time = "Time", qf = 2, qr = 2)
summary(fm1, type="model")
summary(fm1, type="lcc")
}
\seealso{
\code{\link{AIC}}, \code{\link{BIC}},
\code{print.summary.lcc},  \code{\link[lcc]{lcc}}
}
\author{
Thiago de Paula Oliveira,
  \email{thiago.paula.oliveira@alumni.usp.br}
}
