% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gini.index.R
\name{gini.index}
\alias{gini.index}
\title{Measures of Relative Variability -- Gini Index}
\usage{
gini.index(x)
}
\arguments{
\item{x}{the input data.}
}
\value{
A list with the following components:
\item{statistic}{the Gini index.}
\item{parameter}{the mean difference of the set of numbers.}
\item{data.name}{a character string giving the name of the data.}
}
\description{
Gini index for measuring relative inequality (or relative variation) of the data 
\insertCite{Gini_1912}{lawstat}. \code{NA}s from the data are omitted.
}
\details{
See also \insertCite{Gastwirth_1988v1;textual}{lawstat}.
}
\examples{
## The Baker v. Carr Case: one-person-one-vote decision. 
## Measure of Relative Inequality of Population data in 33 districts 
## of the Tennessee Legislature in 1900 and 1972. See 
## popdata (see Gastwirth (1988)).
data(popdata)
gini.index(popdata[,"pop1900"])
gini.index(popdata[,"pop1972"])

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{cd}}, \code{\link{j.maad}}, \code{\link{lorenz.curve}}
}
\author{
Wallace Hui, Yulia R. Gel, Joseph L. Gastwirth, Weiwen Miao
}
\keyword{homogeneity}
\keyword{variability}
