% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ESEM.R
\name{ESEM}
\alias{ESEM}
\title{Estimates Exploratory Structural Equation Model}
\usage{
ESEM(
  data,
  factors,
  variables,
  estimator = c("MLR", "WLSMV"),
  fit_measures = NULL,
  variable_polarity = NULL,
  wording_factor = c("none", "CTCM1", "CTCM1_each", "RI", "RI_each"),
  CTCM1_polarity = c("negative", "positive"),
  ...
)
}
\arguments{
\item{data}{Numeric matrix, data frame, or \code{\link{latentFactoR}} object}

\item{factors}{Numeric (length = 1).
Number of ESEM factors to estimate}

\item{variables}{Numeric (length = 1 or \code{factors}).
Number of variables per factor. A vector the length of the
number of factors can be specified to allow varying
number of variables on each factor (necessary for some
\code{wording_factor} arguments)}

\item{estimator}{Character.
Estimator to be used in \code{\link[lavaan]{cfa}}.
Default options are \code{"MLR"} for continuous data
and \code{"WLSMV"} for categorical data}

\item{fit_measures}{Character.
Fit measures to be computed using \code{\link[lavaan]{fitMeasures}}.
Defaults to: \code{"chisq"}, \code{"df"}, \code{"pvalue"}, \code{"cfi"},
\code{"tli"}, \code{"rmsea"}, \code{"rmsea.ci.lower"},
\code{"rmsea.ci.upper"}, \code{"rmsea.pvalue"}, and \code{"srmr"}.
Other measures can be added but these measures will always be produced.

If scaled values are available (not \code{NA}), then scaled fit measures
will be used.}

\item{variable_polarity}{Numeric/character (length = 1 or total variables).
Whether all (length = 1) or each variable (length = total variables) are
positive (\code{1}, \code{"p"}, \code{"pos"}, \code{"positive"}) or
negative (\code{-1}, \code{"n"}, \code{"neg"}, \code{"negative"})
polarity on the factor}

\item{wording_factor}{Character (length = 1).
Whether wording factor(s) should be estimated.
Defaults to \code{"none"}.
Options include:

\itemize{

\item \code{"CTCM1"} --- Description coming soon...

\item \code{"CTCM1_each"} --- Description coming soon...

\item \code{"RI"} --- Description coming soon...

\item \code{"RI_each"} --- Description coming soon...

}}

\item{CTCM1_polarity}{Character.
Polarity of the CTCM1 wording factor(s).
Defaults to \code{"negative"} for negative
polarity variables}

\item{...}{Additional arguments to be passed on to
\code{\link[lavaan]{cfa}}}
}
\value{
Returns a list containing:

\item{model}{Estimated ESEM model}

\item{fit}{Fit measures of estimated ESEM model}
}
\description{
A general function to estimate an Exploratory Structural
Equation Model (ESEM) using the \code{\link[lavaan]{lavaan}} package.
With \code{\link{latentFactoR}} objects,
the function requires fewer inputs
}
\examples{
# Generate factor data
two_factor <- simulate_factors(
  factors = 2, # factors = 2
  variables = 6, # variables per factor = 6
  loadings = 0.55, # loadings between = 0.45 to 0.65
  cross_loadings = 0.05, # cross-loadings N(0, 0.05)
  correlations = 0.30, # correlation between factors = 0.30
  sample_size = 1000, # number of cases = 1000
  variable_categories = 5 # 5-point Likert scale
)

\dontrun{
# Estimate ESEM model with no wording effects
esem_no_wording_effects <- ESEM(
  data = two_factor,
  estimator = "WLSMV"
)

# Add wording effects using acquiescence method
two_factor_acquiescence <- add_wording_effects(
  lf_object = two_factor,
  proportion_negative = 0.50,
  proportion_biased_cases = 0.10,
  method = "acquiescence"
)

# Estimate ESEM model with wording effects
esem_wording_effects <- ESEM(
  data = two_factor_acquiescence,
  estimator = "WLSMV",
  wording_factor = "RI"
)}

}
\author{
Alexander P. Christensen <alexpaulchristensen@gmail.com>,
Luis Eduardo Garrido <luisgarrido@pucmm.edu>
}
