% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsm_l_lsi.R
\name{lsm_l_lsi}
\alias{lsm_l_lsi}
\title{LSI (landscape level)}
\usage{
lsm_l_lsi(landscape)
}
\arguments{
\item{landscape}{A categorical raster object: SpatRaster; Raster* Layer, Stack, Brick; stars or a list of SpatRasters.}
}
\value{
tibble
}
\description{
Landscape shape index (Aggregation metric)
}
\details{
\deqn{LSI = \frac{E} {\min E}}
where \eqn{E} is the total edge length in cell surfaces and \eqn{\min E}
is the minimum total edge length in cell surfaces.

LSI is an 'Aggregation metric'. It is the ratio between the actual landscape edge length
and the hypothetical minimum edge length. The minimum edge length equals
the edge length if only one patch would be present.

Because the metric is based on distances or areas please make sure your data
is valid using \code{\link{check_landscape}}.

\subsection{Units}{None}
\subsection{Ranges}{LSI >= 1}
\subsection{Behaviour}{Equals LSI = 1 when only one squared patch is present.
Increases, without limit, as the length of the actual edges increases, i.e.
the patches become less compact.}
}
\examples{
landscape <- terra::rast(landscapemetrics::landscape)
lsm_l_lsi(landscape)

}
\references{
McGarigal K., SA Cushman, and E Ene. 2023. FRAGSTATS v4: Spatial Pattern Analysis
Program for Categorical Maps. Computer software program produced by the authors;
available at the following web site: https://www.fragstats.org

Patton, D. R. 1975. A diversity index for quantifying habitat "edge".
Wildl. Soc.Bull. 3:171-173.
}
\seealso{
\code{\link{lsm_p_shape}}, \cr
\code{\link{lsm_c_lsi}}
}
