% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strand.R
\name{strand.extract}
\alias{strand.extract}
\title{Strand Extract}
\usage{
strand.extract(strands, obj)
}
\arguments{
\item{strands}{A list of \code{strands}, which are data frames returned by \code{\link[lakhesis]{ca.procrustes.curve}}.}

\item{obj}{The intial incidence matrix.}
}
\value{
A list of two matrices:
\itemize{
\item \code{Row} A matrix of the ranks of the row elements.
\item \code{Col} A matrix of the ranks of the column elements.
}
}
\description{
From a \code{list} of strands produced by \code{\link[lakhesis]{ca.procrustes.curve}}, extract two matrices containing the ranks of the rows and columns. The row/column elements are contained in the rows, and the strands are contained in the columns. NA values are entered where a given row/column element is missing from that strand.
}
\examples{
data("quattrofontanili")
data("qfStrands")
strand.extract(qfStrands, quattrofontanili)

}
