% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/procrustes.R
\name{ca.procrustes.poly}
\alias{ca.procrustes.poly}
\title{Projection onto Reference Curve}
\usage{
ca.procrustes.poly(obj, resolution = 10000)
}
\arguments{
\item{obj}{An incidence matrix of size n x k.}

\item{resolution}{Number of samples to use for plotting points along polynomial curve (default is 10000).}
}
\value{
A list of the following:.
\itemize{
\item `ref`` The Procrustes-fit coordinates of the scores of the reference seriation.
\item \code{x} The Procrustes-fit coordinates of the row scores of the data.
\item \code{x.dat} A data frame containing the following information related to the fit of the row score after Procrustes fitting: \code{index}, the row name, \code{match}, the reference point nearest to the row score, and \code{dist}, the Euclidean distance between the row score and reference score point.
\item \code{y} The Procrustes-fit coordinates of the column scores of the data.
\item \code{y.dat} A data frame containing the same information as \code{x.dat}, but with respect to the column scores.
}
}
\description{
Performs a polynomial regression on the row reference scores and orthogonally projects data points on to the reference curve. Sampling can be increased to refine ranking and avoid ties, but default is largely sufficient. Correspondence analysis is performed using the \code{\link[ca]{ca}} package \insertCite{nenadic_correspondence_2007}{lakhesis}.
}
\examples{
data("quattrofontanili")
ca.procrustes.poly(quattrofontanili)

}
\references{
\insertAllCited{}
}
