% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multichoice.R
\name{create_multichoice}
\alias{create_multichoice}
\title{Create multichoice exam}
\usage{
create_multichoice(
  data = NULL,
  path = NULL,
  filename = NULL,
  title = NULL,
  question.column = NULL,
  option1.column = NULL,
  option2.column = NULL,
  option3.column = NULL,
  option4.column = NULL,
  image.column = NULL,
  solutions = F,
  start = 1,
  seeds = NULL,
  frontpage = NULL,
  keep.files = FALSE,
  template = NULL
)
}
\arguments{
\item{data}{a data frame including the questions and choices, and may include a column with
adjacent image paths.}

\item{path}{Character. Path to folder where the PDF file will be saved.}

\item{filename}{Character. Filename of the pdf. If NULL, default is "multichoice".}

\item{title}{Title of the exam. If different models are rendered, they will be shown too.}

\item{question.column}{Character. Name of the column in \code{data} storing the question to be shown.}

\item{option1.column}{Character. Name of the column in \code{data} storing the CORRECT answer. It will not
always appear on the first place; options will be randomly sorted.}

\item{option2.column}{Character. Name of the column in \code{data} storing the second choice (INCORRECT).}

\item{option3.column}{Character (optional for 2 choice questions). Name of the column in \code{data}
storing the third choice (INCORRECT).}

\item{option4.column}{Character (optional for 3 choice questions). Name of the column in \code{data}
storing the fourth choice (INCORRECT).}

\item{image.column}{Character (optional). Name of the column containing file paths to an image
which may appear by the side of the question.}

\item{solutions}{Logical. Whether or not a PDF with the solutions should be rendered.}

\item{start}{Numeric. Number of the first question (useful if exams are split in several parts).}

\item{seeds}{Numeric vector of undefined length. Seeds to randomize question order and choice order.
If the length of \code{seeds} is longer than one, a multiple choice exam will be rendered for EACH ONE specified.}

\item{frontpage}{Character (optional). Path to PDF file to be inserted before the document
(as front page and/or instructions).}

\item{keep.files}{Logical. Keep the RMarkdown template and associated files
in the output folder? Default is FALSE.}

\item{template}{Character (optional) RMarkdown template to use. If not provided,
using the default template included in \code{labeleR}.}
}
\value{
A PDF file is saved on disk, in the folder defined
by \code{path}. If \code{keep.files = TRUE}, an RMarkdown file will also appear in the same folder.
}
\description{
Creates a multichoice exam, with 4 questions per page (first one has title plus 3 questions).
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
create_multichoice(
data = multichoice.table,
path = "labeleR_output",
filename = "example_exam",
title = "Example test",
question.column = "question",
option1.column = "opt1.correct",
option2.column = "opt2",
option3.column = "opt3",
option4.column = "opt4",
start = 1,
solutions=T,
seeds = c(1:2)
)
\dontshow{\}) # examplesIf}
}
\author{
Ignacio Ramos-Gutierrez, Jimena Mateo-Martín, Julia G. de Aledo, Francisco Rodriguez-Sanchez
}
