% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kvk_retrieve.R
\name{kvk_get_naamgeving}
\alias{kvk_get_naamgeving}
\title{Retrieve the Naamgeving for a given KvK number}
\usage{
kvk_get_naamgeving(kvkNummer, test_environment = FALSE)
}
\arguments{
\item{kvkNummer}{A string representing the KvK number for which the name
information is requested.}

\item{test_environment}{A logical value indicating whether to use the test
environment (\code{TRUE}) or the production environment (\code{FALSE}). Defaults to
\code{FALSE}.}
}
\value{
A tibble containing the retrieved name information.
}
\description{
This function retrieves the name information (\code{naamgeving}) for a given KvK
number (\code{kvkNummer}) using the KvK Naamgevingen API.
}
\details{
The function also supports the \code{test_environment} argument. When set to
\code{TRUE}, the function will query the KvK test API environment, providing a
set of fictitious test data.

The function retrieves data from the KvK Naamgevingen API.

\strong{Important:} If \code{test_environment = TRUE}, no actual API key is required. You will be using
test data from the KvK test environment.
}
\examples{
\dontshow{if (nzchar(Sys.getenv("KVK_API_KEY"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Examples using the production API (requires API key)
# Retrieve naamgeving for a given KvK number
naamgeving <- kvk_get_naamgeving(kvkNummer = "68750110")
print(naamgeving)

# Examples using test environment (no API key required)
naamgeving_test <- kvk_get_naamgeving(kvkNummer = "68727720", test_environment = TRUE)
print(naamgeving_test)
\dontshow{\}) # examplesIf}
}
