% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{geweke}
\alias{geweke}
\alias{geweke.krige}
\alias{geweke.summary.krige}
\alias{geweke.default}
\title{Geweke Diagnostic for MCMC}
\usage{
geweke(object, early.prop = 0.1, late.prop = 0.5, precision = 4)

\method{geweke}{krige}(object, early.prop = 0.1, late.prop = 0.5, precision = 4)

\method{geweke}{summary.krige}(object, early.prop = 0.1, late.prop = 0.5, precision = 4)

\method{geweke}{default}(object, early.prop = 0.1, late.prop = 0.5, precision = 4)
}
\arguments{
\item{object}{An matrix or \code{krige}/\code{summary.krige} object for which 
a Geweke diagnostic is desired}

\item{early.prop}{Proportion of iterations to use from the start of the chain.}

\item{late.prop}{Proportion of iterations to use from the end of the chain.}

\item{precision}{Number of digits of test statistics and p-values to print.}
}
\value{
A \code{matrix} in which the first row consists of z-scores for tests 
  of equal means for the first and last parts of the chain. The second row 
  consists of the corresponding p-values. Each column of the matrix represents 
  another parameter. For each column, a significant result is evidence that the 
  chain has not converged for that parameter. Thus, a non-significant result 
  is desired.
}
\description{
Conducts a Geweke convergence diagnostic on MCMC iterations.
}
\details{
This is a generic function currently works with \code{matrix}, \code{krige}, 
  and \code{summary.krige} objects. It is a simplified version of the Geweke 
  test for use with this package.
  
  Geweke's (1992) test for nonconvergence of a MCMC chain is to conduct a 
  difference-of-means test that compares the mean early in the chain to the mean 
  late in the chain. If the means are significantly different from each other, 
  then this is evidence that the chain has not converged. The difference-of-means 
  test is a simple z-ratio, though the standard error is estimated using the 
  spectral density at zero to account for autocorrelation in the chain.
}
\examples{
\dontrun{
# Load Data
data(ContrivedData)

# Set seed
set.seed(1241060320)

M <- 100

contrived.run <- metropolis.krige(y ~ x.1 + x.2, coords = c("s.1","s.2"), 
  data = ContrivedData, n.iter = M, range.tol = 0.05)

geweke(contrived.run, early.prop=0.5)
geweke(summary(contrived.run), early.prop=0.5)
geweke(contrived.run$mcmc.mat, early.prop=0.5)
# Note that the default proportions in the geweke() is more typical for longer run.
}

}
\references{
John Geweke. 1992. "Evaluating the Accuracy of Sampling-Based Approaches to 
  the Calculation of Posterior Moments." In \emph{Bayesian Statistics 4}, ed. 
  J.M. Bernardo, J.O. Berger, A.P. Dawid, and A.F.M. Smith. Oxford: Clarendon 
  Press.
}
\seealso{
\code{\link{geweke.krige}}, \code{\link{geweke.summary.krige}}
}
