% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStatData.R
\name{getStatData}
\alias{getStatData}
\title{KOSIS Statistic Data}
\usage{
getStatData(
  orgId,
  tblId,
  prdSe = c("Y", "H", "Q", "M", "D", "IR"),
  startPrdDe,
  endPrdDe,
  newEstPrdCnt = 3,
  prdInterval = 1,
  itmId = "ALL",
  objL1 = "ALL",
  objL2 = "",
  objL3 = "",
  objL4 = "",
  ...
)
}
\arguments{
\item{orgId}{A string specifying the organization id}

\item{tblId}{A string specifying the table id}

\item{prdSe}{A string specifying the period symbol (Y, H, Q, M, D, IR: Irregularly)}

\item{startPrdDe}{A string specifying start period
(format: YYYY, YYYYMM(MM:01~12), YYYYHH(HH:01,02), YYYYQQ(QQ:01~04), YYYYMMDD)}

\item{endPrdDe}{A string specifying end period
(format: YYYY, YYYYMM(MM:01~12), YYYYHH(HH:01,02), YYYYQQ(QQ:01~04), YYYYMMDD)}

\item{newEstPrdCnt}{A string specifying newest period count}

\item{prdInterval}{A string specifying period interval}

\item{itmId}{A string item id}

\item{objL1}{A string specifying object level 1}

\item{objL2}{A string specifying object level 2}

\item{objL3}{A string specifying object level 3}

\item{objL4}{A string specifying object level 4}

\item{...}{A string specifying object level 5, 6, 7, 8 (objL5, objL6, objL7, objL8)}
}
\value{
A data.frame object containing queried information
}
\description{
KOSIS Statistic Data
}
\details{
\preformatted{
## Example
getStatData(orgId = "101", tblId = "DT_1B41")
}
}
