% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VisualizationFunctions.R
\name{fixation_plot_ts}
\alias{fixation_plot_ts}
\title{Plot fixation classified vs. raw gaze coordinate time series}
\usage{
fixation_plot_ts(
  data_in,
  plot.window = c(NA, NA),
  x.index.var = "timestamp",
  var1 = "x.raw",
  var2 = "x",
  xres = 1920,
  yres = 1080,
  verbose = TRUE,
  algorithm.name = "fixation.algorithm",
  ylim = NA,
  font.size = 15
)
}
\arguments{
\item{data_in}{gaze matrix which must include columns for filtered and unfiltered data as specified in the var1 and var2 paramters}

\item{plot.window}{vector defining the time window to plot. Correxponding values must be found in the variable specified in the parameter x.index.var (default: timestamp)
in the data found in the variable 'timestamp'}

\item{x.index.var}{Name of the variable to plot on the X axis, for example timestamp or sample index. If the default setting is used, gaze coordinates are plotted against
timestamp (stored in a variable with that name). It can be replaced with any other numerical variable present in the data.}

\item{var1}{Name of the first variable to plot. Default "x.raw"}

\item{var2}{Name of the second variable to plot (overlayed on var1) Default: "x"}

\item{xres}{Maximum of the X axis (horizontal resolution of the screen or area to plot on). Default 1920}

\item{yres}{Maximum of the Y axis (vertical resolution of the screen or area to plot on). Default 1080}

\item{verbose}{If TRUE, print the resulting plot}

\item{algorithm.name}{Name of the fixation algorithm/or preprocessing procedure used for this data. The default is "fixation.algorithm" which is automatically stored in the output of kollaR
fixation classification algorithm. It can be replaced by another variable name. If different categories exist, each will be plotted in a separate subplot.}

\item{ylim}{Limits of y axis. If NA, the Y axis covers the range in the input data, otherwise it's restricted to the values in ylim. ylim = c(0, 1920) sets
the minimum and maximum values on the Y acus to 0 and 1920 respectively}

\item{font.size}{Font size}
}
\value{
a ggplot with gaze coordinates plotted on the y axis and sample number on the x axis
}
\description{
This function plots and returns a ggplot2 figure showing time series of gaze coordinates plotted against time.
The interval to plot must be specified in the same unit as the vaiable specified in the input variable x.index.var. By default, this
variable is called timestamp. Use this function to compare the raw gaze coordinates to the output from one or more fixation classification algorithms.
Either the X or the Y coordinates are plotted.
If the variable specified in the parameter algorithm.name is present in the input data AND contains more than one unique category, you will get subplots for each category.
For example, if the input data contains fixation and raw coordinates for data from the I-VT and I2MC algorithms, each will be plotted in a separate subplot. Note that the
X index variable (time stamps or sample number) must be the same.
}
\examples{
new.plot <- fixation_plot_ts (sample.data.classified, plot.window = c(1000, 2000))
}
