% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VisualizationFunctions.R
\name{filt_plot_temporal}
\alias{filt_plot_temporal}
\title{Plot fixation filtered vs. raw gaze coordinates. This function will be replaced by fixation_plot_temporal in future releases. It is currently a wrapper around
fixation_plot_temporal accepting the same arguments.}
\usage{
filt_plot_temporal(
  data_in,
  plot.window = c(NA, NA),
  var1 = "x.raw",
  var2 = "x",
  x.index.var = "sample.index",
  verbose = TRUE
)
}
\arguments{
\item{data_in}{gaze matrix which must include columns for filtered and unfiltered data as specified in the var1 and var2 paramters}

\item{plot.window}{vector defining the time window to plot. If left empty, the 50-65% interval of the data are plotted. If the submitted values are
<0, they are assumed to be proportions, e.g., \code{plot.window = c(0.3,0.35)} plots the 30-35% interval of the data. Numbers >1 are assumed to refer to time stamps
in the data found in the variable 'timestamp'}

\item{var1}{Name of the first variable to plot. Default "x.raw"}

\item{var2}{Name of the second variable to plot (overlayed on var1) Default: "x"}

\item{x.index.var}{Name of the variable to plot on the X axis, for example timestamp or sample index. If the default setting is used, gaze coordinates are plotted against
sample number in the selected data interval.}

\item{verbose}{If TRUE, print the resulting plot}
}
\value{
a ggplot with gaze coordinates plotted on the y axis and sample number on the x axis
}
\description{
This function plots and returns a ggplot2 figure showing two time series of gaze coordinates plotted against time.
The interval to plot can be defined as a proportion of the data frame, by timestamps, or by sample numbers. Use this function to plot data before and after processing or filtering
to examine their effects. For example, unprocessed x or y coordinates can be plotted against x and y coordinates following pre-processing and/or event detection with a
fixation detection algorithm
Either the x or the y vector is plotted
}
\examples{
new.plot <- filt_plot_temporal(sample.data.classified, plot.window = c(1000, 2000))
}
