% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matching.R
\name{matching}
\alias{matching}
\title{A pair distance for binary/ categorical variables}
\usage{
matching(x, y)
}
\arguments{
\item{x}{A first data frame or matrix (see \strong{Details}).}

\item{y}{A second data frame or matrix (see \strong{Details}).}
}
\value{
Function returns a distance matrix with the number of rows equal to
the number of objects in the \code{x} data frame/ matrix (\eqn{n_x}) and
the number of columns equals to the number of objects in the \code{y}
data frame/ matrix (\eqn{n_y}).
}
\description{
This function computes the simple matching distance from
two data frames/ matrices.
}
\details{
The \code{x} and \code{y} arguments have to be data frames/
matrices with the same number of columns where the row indicates the object
and the column is the variable. This function calculates all pairwise
distance between rows in the \code{x} and \code{y} data frames/ matrices.
If the \code{x} data frame/ matrix is equal to the \code{y} data frame/
matrix, it explicitly calculates all distances in the \code{x} data frame/
matrix.

The simple matching distance between objects i and j is
calculated by
\deqn{d_{ij} = \frac{\sum_{s=1}^{P}(x_{is}-x_{js})}{P}}
where  \eqn{P} is the number of variables, and \eqn{ x_{is}-x_{js} \in}
\{0, 1\}. \eqn{ x_{is}-x_{js} = 0}, if \eqn{ x_{is}=x_{js}} and
\eqn{x_{is}-x_{js} = 1}, when \eqn{x_{is} \neq x_{js}}.

As an example, the distance between objects 1 and 2 is presented.

\tabular{lrrr}{
object \tab x \tab y \tab z \cr
1 \tab 1 \tab 2 \tab 2 \cr
2 \tab 1 \tab 2 \tab 1
}

The distance between objects 1 and 2 is
\deqn{d_{12} = \frac{\sum_{s=1}^{3}(x_{is}-x_{js})}{3} = \frac{0 + 0 + 1}{3} =
\frac{1}{3} = 0.33}
}
\examples{
set.seed(1)
a <- matrix(sample(1:2, 7*3, replace = TRUE), 7, 3)
matching(a, a)

}
\author{
Weksi Budiaji \cr Contact: \email{budiaji@untirta.ac.id}
}
