% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kmeRtone.R
\name{kmeRtone}
\alias{kmeRtone}
\title{kmeRtone all-in-one user interface}
\usage{
kmeRtone(
  case.coor.path,
  genome.name,
  strand.sensitive,
  k,
  ctrl.rel.pos = c(80, 500),
  case.pattern,
  output.dir = "output/",
  case,
  genome,
  control,
  control.path,
  genome.path,
  rm.case.kmer.overlaps,
  single.case.len,
  merge.replicates,
  kmer.table,
  module = "score",
  rm.dup = TRUE,
  case.coor.1st.idx = 1,
  ctrl.coor.1st.idx = 1,
  coor.load.limit = 1,
  genome.load.limit = 1,
  genome.fasta.style = "UCSC",
  genome.ncbi.db = "refseq",
  use.UCSC.chr.name = FALSE,
  verbose = TRUE,
  kmer.cutoff = 5,
  selected.extremophiles,
  other.extremophiles,
  cosmic.username,
  cosmic.password,
  tumour.type.regex = NULL,
  tumour.type.exact = NULL,
  cell.type = "somatic",
  genic.elements.counts.dt,
  population.size = 1e+06,
  selected.genes,
  add.to.existing.population = FALSE,
  population.snv.dt = NULL,
  pop.plot = TRUE,
  pop.loop.chr = FALSE
)
}
\arguments{
\item{case.coor.path}{Path to a folder containing chromosome-separated coordinate
files or bedfiles. Assumed replicates for subfolder or bedfiles.}

\item{genome.name}{Name of the genome (e.g., "hg19", "hg38"). Default is "unknown".}

\item{strand.sensitive}{Logical value indicating whether strand polarity matters.
Default is TRUE.}

\item{k}{Length of k-mer to be investigated. Recommended values are 7 or 8.}

\item{ctrl.rel.pos}{A vector of two integers specifying the relative range positions
of control regions.}

\item{case.pattern}{Regular expression pattern for identifying case regions.
Default is NULL.}

\item{output.dir}{Directory path for saving output files. Default is "output/".}

\item{case}{Optional pre-built Coordinate object.}

\item{genome}{Optional pre-built Genome object.}

\item{control}{Optional pre-built control Coordinate object.}

\item{control.path}{Path for pre-built control Coordinate object.}

\item{genome.path}{Path to a directory of user-provided genome FASTA files.}

\item{rm.case.kmer.overlaps}{Logical indicating whether to remove overlapping
k-mers in case regions. Default is FALSE.}

\item{single.case.len}{Integer indicating uniform length of case regions.}

\item{merge.replicates}{Logical indicating whether to merge replicates.
Default is TRUE.}

\item{kmer.table}{Pre-calculated k-mer score table.}

\item{module}{Selected kmeRtone module to run. Possible values include "score",
"explore", "tune", among others.}

\item{rm.dup}{Logical indicating whether to remove duplicate coordinates.
Default is TRUE.}

\item{case.coor.1st.idx}{Integer specifying indexing format for case coordinates.}

\item{ctrl.coor.1st.idx}{Integer specifying indexing format for control coordinates.}

\item{coor.load.limit}{Maximum number of coordinates to load. Default is 1.}

\item{genome.load.limit}{Maximum number of genome sequences to load. Default is 1.}

\item{genome.fasta.style}{String specifying the style of the genome FASTA.
Possible values are "UCSC", "NCBI". Default is "UCSC".}

\item{genome.ncbi.db}{String specifying the NCBI database to use. Possible values
are "refseq", "genbank". Default is "refseq".}

\item{use.UCSC.chr.name}{Logical indicating whether to use UCSC chromosome names.}

\item{verbose}{Logical indicating whether to display progress messages.
Default is TRUE.}

\item{kmer.cutoff}{Cutoff percentage for k-mer selection in case studies.
Default is 5.}

\item{selected.extremophiles}{Vector of selected extremophile species for study.}

\item{other.extremophiles}{Vector of other extremophile species for control.}

\item{cosmic.username}{COSMIC username for accessing the cancer gene census.}

\item{cosmic.password}{COSMIC password for accessing the cancer gene census.}

\item{tumour.type.regex}{Regular expression pattern for filtering tumour types.}

\item{tumour.type.exact}{Exact tumour type to be included in the cancer gene census.}

\item{cell.type}{Cell type to be included in the cancer gene census. Default is
"somatic".}

\item{genic.elements.counts.dt}{Data table of susceptible k-mer counts in genic
elements.}

\item{population.size}{Size of the population for cross-population studies.
Default is 1 million.}

\item{selected.genes}{Selected genes for mutation in cross-population studies.}

\item{add.to.existing.population}{Logical indicating whether to add to the existing
simulated population. Default is FALSE.}

\item{population.snv.dt}{Data table of single nucleotide variants used in
population simulations.}

\item{pop.plot}{Logical indicating whether to plot the outcome of the cross-population
study. Default is TRUE.}

\item{pop.loop.chr}{Logical indicating whether to loop based on chromosome name
in cross-population studies. Default is FALSE.}
}
\value{
Depends on the selected module.
}
\description{
This function serves as an all-in-one interface for various genomic data analyses
leveraging k-mer based techniques.
}
