% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STUDY_GENIC_ELEMENTS.R
\name{STUDY_GENIC_ELEMENTS}
\alias{STUDY_GENIC_ELEMENTS}
\title{Study k-mer composition across species.}
\usage{
STUDY_GENIC_ELEMENTS(
  kmer.table,
  kmer.cutoff = 5,
  k,
  genome.name = "hg38",
  central.pattern = NULL,
  db = "refseq",
  output.dir = "study_genic_elements/",
  fasta.path
)
}
\arguments{
\item{kmer.table}{A data.table of kmer table.}

\item{kmer.cutoff}{Percentage of extreme kmers to study. Default to 5.}

\item{k}{K-mer size.}

\item{genome.name}{UCSC genome name.}

\item{central.pattern}{K-mer's central patterns. Default is NULL.}

\item{db}{Database used by UCSC to generate gene prediction: "refseq" or
"gencode". Default is "refseq".}

\item{output.dir}{A directory for the outputs.}

\item{fasta.path}{Path to a directory of user-provided genome FASTA files or
the destination to save the NCBI/UCSC downloaded reference genome files.}
}
\value{
An output directory containing plots.
}
\description{
Study k-mer composition across species.
}
