% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kld-uncertainty.R
\name{kld_ci_bootstrap}
\alias{kld_ci_bootstrap}
\title{Uncertainty of KL divergence estimate using Efron's bootstrap.}
\usage{
kld_ci_bootstrap(
  X,
  Y,
  estimator = kld_est_kde1,
  B = 500L,
  alpha = 0.05,
  method = c("quantile", "se"),
  include.boot = FALSE,
  ...
)
}
\arguments{
\item{X, Y}{\code{n}-by-\code{d} and \code{m}-by-\code{d} matrices, representing \code{n} samples from
the true distribution \eqn{P} and \code{m} samples from the approximate distribution
\eqn{Q}, both in \code{d} dimensions. Vector input is treated as a column matrix.}

\item{estimator}{A function expecting two inputs \code{X} and \code{Y}, the
Kullback-Leibler divergence estimation method. Defaults to \code{kld_est_kde1},
which can only deal with one-dimensional two-sample problems (i.e.,
\code{d = 1} and \code{q = NULL}).}

\item{B}{Number of bootstrap replicates (default: \code{500}), the larger, the
more accurate, but also more computationally expensive.}

\item{alpha}{Error level, defaults to \code{0.05}.}

\item{method}{Either \code{"quantile"} (the default), also known as the reverse
percentile method, or \code{"se"} for a normal approximation of the KL
divergence estimator using the standard error of the subsamples.}

\item{include.boot}{Boolean, \code{TRUE} means KL divergene estimates on bootstrap
samples are included in the returned list.}

\item{...}{Arguments passed on to \code{estimator}, i.e. as \code{estimator(X, Y, ...)}.}
}
\value{
A list with the following fields:
\itemize{
\item \code{"est"} (the estimated KL divergence),
\item \code{"boot"} (a length \code{B} numeric vector with KL divergence estimates on
the bootstrap subsamples), only included if \code{include.boot = TRUE},
\item \code{"ci"} (a length \code{2} vector containing the lower and upper limits of the
estimated confidence interval).
}
}
\description{
This function computes a confidence interval for KL divergence based on Efron's
bootstrap. The approach only works for kernel density-based estimators since
nearest neighbour-based estimators cannot deal with the ties produced when
sampling with replacement.
}
\details{
Reference:

Efron, "Bootstrap Methods: Another Look at the Jackknife", The Annals of
Statistics, Vol. 7, No. 1 (1979).
}
\examples{
# 1D Gaussian, two samples
set.seed(0)
X <- rnorm(100)
Y <- rnorm(100, mean = 1, sd = 2)
kld_gaussian(mu1 = 0, sigma1 = 1, mu2 = 1, sigma2 = 2^2)
kld_est_kde1(X, Y)
kld_ci_bootstrap(X, Y)

}
