% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row-id.R
\name{make_id}
\alias{make_id}
\title{Create ID from columns}
\usage{
make_id(.data, ..., .id = ".id", .sep = "|")
}
\arguments{
\item{.data}{A data frame.}

\item{...}{Columns to combine into the ID.}

\item{.id}{Column name for the ID (default: ".id").}

\item{.sep}{Separator between column values (default: "|").}
}
\value{
Data frame with ID column added.
}
\description{
Creates an ID column by combining values from one or more columns.
Unlike \code{\link[=add_id]{add_id()}}, this produces deterministic IDs based on column values.
}
\examples{
df <- data.frame(country = c("US", "UK", "US"), year = c(2020, 2020, 2021))
make_id(df, country, year)
#>   .id       country year
#> 1 US|2020  US      2020
#> 2 UK|2020  UK      2020
#> 3 US|2021  US      2021

}
