% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-merge.R
\name{layer_average}
\alias{layer_average}
\title{Layer that averages a list of inputs.}
\usage{
layer_average(inputs, ...)
}
\arguments{
\item{inputs}{A input tensor, or list of input tensors. Can be missing.}

\item{...}{Unnamed args are treated as additional \code{inputs}. Named arguments are passed on as standard layer arguments.}
}
\value{
A tensor, the average of the inputs. If \code{inputs} is missing, a keras
layer instance is returned.
}
\description{
It takes as input a list of tensors, all of the same shape, and returns a
single tensor (also of the same shape).
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/average}
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/Average}
\item \url{https://keras.io/api/layers/merging_layers/average}
}

Other merge layers: 
\code{\link{layer_concatenate}()},
\code{\link{layer_dot}()},
\code{\link{layer_maximum}()},
\code{\link{layer_minimum}()},
\code{\link{layer_multiply}()},
\code{\link{layer_subtract}()}
}
\concept{merge layers}
