% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend.R
\name{k_conv3d}
\alias{k_conv3d}
\title{3D convolution.}
\usage{
k_conv3d(
  x,
  kernel,
  strides = c(1, 1, 1),
  padding = "valid",
  data_format = NULL,
  dilation_rate = c(1, 1, 1)
)
}
\arguments{
\item{x}{Tensor or variable.}

\item{kernel}{kernel tensor.}

\item{strides}{strides}

\item{padding}{string, \code{"same"} or \code{"valid"}.}

\item{data_format}{string, \code{"channels_last"} or \code{"channels_first"}. Whether
to use Theano or TensorFlow/CNTK data format for inputs/kernels/outputs.}

\item{dilation_rate}{list of 3 integers.}
}
\value{
A tensor, result of 3D convolution.
}
\description{
3D convolution.
}
\section{Keras Backend}{


This function is part of a set of Keras backend functions that enable
lower level access to the core operations of the backend tensor engine
(e.g. TensorFlow, CNTK, Theano, etc.).

You can see a list of all available backend functions here:
\url{https://tensorflow.rstudio.com/reference/keras/index.html#backend}.
}

