% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{fuel_mix}
\alias{fuel_mix}
\title{Mix of fuels contributing to primary energy supply for many countries and
regions}
\format{
A tibble containing 948 rows and 7 variables
\describe{
\item{region}{Country or region name}
\item{region_code}{Three-letter country or region code}
\item{geography}{Geographic category: "nation", "region", or "world"}
\item{year}{The year}
\item{fuel}{The fuel: "Coal", "Natural Gas", "Oil", "Nuclear", "Hydro",
and "Renewables"}
\item{quads}{The number of quads of that fuel consumed in the given country
or region and year}
\item{frac}{The fraction of that country or region's total primary
energy consumption from the fuel}
}
}
\source{
\url{https://www.energyinst.org/statistical-review/resources-and-data-downloads}
}
\usage{
fuel_mix
}
\description{
A dataset containing the fuel mix of how many quads and what fraction of
total primary energy supply comes from coal, gas, oil, nuclear, and
renewable sources.
}
\note{
The data for 2022,
from the 2023 release of the Energy Institute's Statistical Review,
has inconsistencies in the fuel
mix for Hong Kong and Sri Lanka: The percentages add up to 98.7\% and
102.9\%, respectively. The sums of energy in quads are off by
-0.095 and +0.095 quads, respectively, from the total energy figure.
}
\seealso{
\link{regions}, \code{\link[=get_fuel_mix]{get_fuel_mix()}}
}
\keyword{datasets}
