% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longrun.R
\name{kardl_longrun}
\alias{kardl_longrun}
\title{Calculating the long-run parameters}
\usage{
kardl_longrun(model)
}
\arguments{
\item{model}{the model produced by kardl}
}
\value{
a list of class kardl with the following elements:
\itemize{
\item type: the type of the model, in this case "kardl_longrun"
\item coef: the estimated coefficients of the long-run parameters
\item delta_se: the standard errors of the long-run parameters
\item results: a data frame with the estimated coefficients, standard errors, t-values, p-values, and significance stars
\item starsDesc: a description of the significance stars used in the results
}
}
\description{
All long-run estimated parameters are standardized by dividing them by the negative of the long-run parameter of the dependent variable.
}
\details{
This function is used to calculate the long-run parameters of a model produced by the \code{kardl} function.

It calculates the long-run multipliers and their standard errors, and returns a list containing the kardl_longrun coefficients, standard errors, and a data frame with the results.
}
\examples{
kardl_model<-kardl(imf_example_data,
                  CPI~ER+PPI+asym(ER)+deterministic(covid)+trend,
                  mode=c(1,2,3,0))
kardl_longrun(kardl_model)

# Using magrittr
library(magrittr)

imf_example_data \%>\% kardl(CPI~ER+PPI+asym(ER)+deterministic(covid)+trend,
                  mode=c(1,2,3,0)) \%>\% kardl_longrun()
}
\seealso{
\code{\link{kardl}}, \code{\link{pssf}}, \code{\link{psst}}
}
