% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr-joins.R
\name{anti_join}
\alias{anti_join}
\title{Anti join on two data frames}
\usage{
anti_join(
  x,
  y,
  by = intersect(names(x), names(y)),
  copy = FALSE,
  suffix = c(".x", ".y"),
  keep = NULL,
  na_matches = c("na", "never"),
  multiple = "all",
  relationship = "many-to-many",
  y_vars_to_keep = FALSE,
  reportvar = getOption("joyn.reportvar"),
  reporttype = c("factor", "character", "numeric"),
  roll = NULL,
  keep_common_vars = FALSE,
  sort = TRUE,
  verbose = getOption("joyn.verbose"),
  ...
)
}
\arguments{
\item{x}{data frame: referred to as \emph{left} in R terminology, or \emph{master} in
Stata terminology.}

\item{y}{data frame: referred to as \emph{right} in R terminology, or \emph{using} in
Stata terminology.}

\item{by}{a character vector of variables to join by. If NULL, the default,
joyn will do a natural join, using all variables with common names across
the two tables. A message lists the variables so that you can check they're
correct (to suppress the message, simply explicitly list the variables that
you want to join). To join by different variables on x and y use a vector
of expressions. For example, \code{by = c("a = b", "z")} will use "a" in \code{x},
"b" in \code{y}, and "z" in both tables.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}

\item{keep}{Should the join keys from both \code{x} and \code{y} be preserved in the
output?
\itemize{
\item If \code{NULL}, the default, joins on equality retain only the keys from \code{x},
while joins on inequality retain the keys from both inputs.
\item If \code{TRUE}, all keys from both inputs are retained.
\item If \code{FALSE}, only keys from \code{x} are retained. For right and full joins,
the data in key columns corresponding to rows that only exist in \code{y} are
merged into the key columns from \code{x}. Can't be used when joining on
inequality conditions.
}}

\item{na_matches}{Should two \code{NA} or two \code{NaN} values match?
\itemize{
\item \code{"na"}, the default, treats two \code{NA} or two \code{NaN} values as equal, like
\code{\%in\%}, \code{\link[=match]{match()}}, and \code{\link[=merge]{merge()}}.
\item \code{"never"} treats two \code{NA} or two \code{NaN} values as different, and will
never match them together or to any other values. This is similar to joins
for database sources and to \code{base::merge(incomparables = NA)}.
}}

\item{multiple}{Handling of rows in \code{x} with multiple matches in \code{y}.
For each row of \code{x}:
\itemize{
\item \code{"all"}, the default, returns every match detected in \code{y}. This is the
same behavior as SQL.
\item \code{"any"} returns one match detected in \code{y}, with no guarantees on which
match will be returned. It is often faster than \code{"first"} and \code{"last"}
if you just need to detect if there is at least one match.
\item \code{"first"} returns the first match detected in \code{y}.
\item \code{"last"} returns the last match detected in \code{y}.
}}

\item{relationship}{Handling of the expected relationship between the keys of
\code{x} and \code{y}. If the expectations chosen from the list below are
invalidated, an error is thrown.
\itemize{
\item \code{NULL}, the default, doesn't expect there to be any relationship between
\code{x} and \code{y}. However, for equality joins it will check for a many-to-many
relationship (which is typically unexpected) and will warn if one occurs,
encouraging you to either take a closer look at your inputs or make this
relationship explicit by specifying \code{"many-to-many"}.

See the \emph{Many-to-many relationships} section for more details.
\item \code{"one-to-one"} expects:
\itemize{
\item Each row in \code{x} matches at most 1 row in \code{y}.
\item Each row in \code{y} matches at most 1 row in \code{x}.
}
\item \code{"one-to-many"} expects:
\itemize{
\item Each row in \code{y} matches at most 1 row in \code{x}.
}
\item \code{"many-to-one"} expects:
\itemize{
\item Each row in \code{x} matches at most 1 row in \code{y}.
}
\item \code{"many-to-many"} doesn't perform any relationship checks, but is provided
to allow you to be explicit about this relationship if you know it
exists.
}

\code{relationship} doesn't handle cases where there are zero matches. For that,
see \code{unmatched}.}

\item{y_vars_to_keep}{character: Vector of variable names in \code{y} that will be
kept after the merge. If TRUE (the default), it keeps all the brings all
the variables in y into x. If FALSE or NULL, it does not bring any variable
into x, but a report will be generated.}

\item{reportvar}{character: Name of reporting variable. Default is ".joyn".
This is the same as variable "_merge" in Stata after performing a merge. If
FALSE or NULL, the reporting variable will be excluded from the final
table, though a summary of the join will be display after concluding.}

\item{reporttype}{character: One of \emph{"character"} or \emph{"numeric"}. Default is
\emph{"character"}. If \emph{"numeric"}, the reporting variable will contain  numeric
codes of the source and the contents of each observation in the joined
table. See below for more information.}

\item{roll}{double: \emph{to be implemented}}

\item{keep_common_vars}{logical: If TRUE, it will keep the original variable
from y when both tables have common variable names. Thus, the prefix "y."
will be added to the original name to distinguish from the resulting
variable in the joined table.}

\item{sort}{logical: If TRUE, sort by key variables in \code{by}. Default is
FALSE.}

\item{verbose}{logical: if FALSE, it won't display any message (programmer's
option). Default is TRUE.}

\item{...}{
  Arguments passed on to \code{\link[=joyn]{joyn}}
  \describe{
    \item{\code{match_type}}{character: one of \emph{"m:m"}, \emph{"m:1"}, \emph{"1:m"}, \emph{"1:1"}.
Default is \emph{"1:1"} since this the most restrictive. However, following
Stata's recommendation, it is better to be explicit and use any of the
other three match types (See details in \emph{match types sections}).}
    \item{\code{update_NAs}}{logical: If TRUE, it will update NA values of all variables
in x with actual values of variables in y that have the same name as the
ones in x. If FALSE, NA values won't be updated, even if \code{update_values} is
\code{TRUE}}
    \item{\code{update_values}}{logical: If TRUE, it will update all values of variables
in x with the actual of variables in y with the same name as the ones in x.
\strong{NAs from y won't be used to update actual values in x}. Yet, by default,
NAs in x will be updated with values in y. To avoid this, make sure to set
\code{update_NAs = FALSE}}
    \item{\code{allow.cartesian}}{logical: Check documentation in official \href{https://rdatatable.gitlab.io/data.table/reference/merge.html/}{web site}.
Default is \code{NULL}, which implies that if the join is "1:1" it will be
\code{FALSE}, but if the join has any "m" on it, it will be converted to \code{TRUE}.
By specifying \code{TRUE} of \code{FALSE} you force the behavior of the join.}
    \item{\code{suffixes}}{A character(2) specifying the suffixes to be used for making
non-by column names unique. The suffix behaviour works in a similar fashion
as the \link[base:merge]{base::merge} method does.}
    \item{\code{yvars}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}: use now \code{y_vars_to_keep}}
    \item{\code{keep_y_in_x}}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}: use now
\code{keep_common_vars}}
    \item{\code{msg_type}}{character: type of messages to display by default}
    \item{\code{na.last}}{ \code{logical}. If \code{TRUE}, missing values in the data are placed last; if \code{FALSE}, they are placed first; if \code{NA} they are removed.
\code{na.last=NA} is valid only for \code{x[order(., na.last)]} and its
default is \code{TRUE}. \code{setorder} and \code{setorderv} only accept
\code{TRUE}/\code{FALSE} with default \code{FALSE}. }
  }}
}
\value{
An data frame of the same class as \code{x}. The properties of the output
are as close as possible to the ones returned by the dplyr alternative.
}
\description{
This is a \code{joyn} wrapper that works in a similar fashion to
\link[dplyr:filter-joins]{dplyr::anti_join}
}
\examples{
# Simple anti join
library(data.table)

x1 = data.table(id = c(1L, 1L, 2L, 3L, NA_integer_),
                t  = c(1L, 2L, 1L, 2L, NA_integer_),
                x  = 11:15)
y1 = data.table(id = c(1,2, 4),
                y  = c(11L, 15L, 16))
anti_join(x1, y1, relationship = "many-to-one")
}
\seealso{
Other dplyr alternatives: 
\code{\link{full_join}()},
\code{\link{inner_join}()},
\code{\link{left_join}()},
\code{\link{right_join}()}
}
\concept{dplyr alternatives}
