% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vectors.R
\name{fround_clu_triplet}
\alias{fround_clu_triplet}
\title{Format and round a single central/lower/upper value set by magnitude without units}
\usage{
fround_clu_triplet(clu, metric, style_name = "nature", mag = NULL)
}
\arguments{
\item{clu}{[num] a numeric triplet of three values in central/lower/upper order}

\item{metric}{[chr c('prop', 'pp', 'count', or 'rate')] metric type - proportion,
percentage point, count, or rate}

\item{style_name}{[chr: default 'nature'] style name - controls rounding and formatting}

\item{mag}{[chr: default NULL] magnitude override - see set_magnitude()
- For props/pp: "as-is" (no scaling, use values as provided)
- For counts: "t" (thousand), "m" (million), "b" (billion)
- For rates: "per10", "per100", "per1k", ..., "per10b"}
}
\value{
[list] with elements:
  - formatted: chr[3] - formatted central, lower, upper values
  - df_mag_row: data.frame[1,] - magnitude info (mag, mag_label, denom)
}
\description{
`central` could be mean/median/point_estimate. `metric` is required (count
data requires nuanced logic), but labels are not returned.
}
\details{
Format and round without unit labeling
- Use `format_lancet_clu()` for unit labels
}
\seealso{
Other styled_formats: 
\code{\link{format_journal_clu}()},
\code{\link{format_journal_df}()},
\code{\link{format_lancet_clu}()},
\code{\link{format_lancet_df}()},
\code{\link{format_metric_cols}()},
\code{\link{format_nature_clu}()},
\code{\link{format_nature_df}()},
\code{\link{new_style}()}
}
\concept{styled_formats}
\keyword{internal}
