% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{add_inferred_sample}
\alias{add_inferred_sample}
\title{Insert an a hypothetical inferred sample into the sample tree and set it
as the parent of specified samples.}
\usage{
add_inferred_sample(
  tables,
  name,
  rank = NULL,
  samples = character(),
  parent_sample = NULL,
  display_name = "Inferred"
)
}
\arguments{
\item{tables}{A list of tables (samples, phylogeny, compositions, ranks)}

\item{name}{The name of the inferred sample to add}

\item{rank}{The rank of the inferred sample}

\item{samples}{A character vector of samples to set the inferred sample as their parent}

\item{parent_sample}{The parent sample of the inferred sample. If NULL, the inferred root is used.}

\item{display_name}{The display name of the inferred sample (default: "Inferred")}
}
\value{
A list of tables with a newly added inferred sample and updated parent relationships
}
\description{
Insert an a hypothetical inferred sample into the sample tree and set it
as the parent of specified samples.
}
\examples{
jellyfisher_example_tables |>
  select_patients("EOC153") |>
  add_inferred_sample("EOC153_Inf",
                      2,
                      c("EOC153_iPer1_DNA4",
                        "EOC153_iOme1_DNA4",
                        "EOC153_iOvaR1_DNA1")) |>
  jellyfisher()

}
