\name{WS}
\alias{WS}
\title{Stem Weight (WS)}
\description{
The Stem Weight (WS) is estimated using the stem diameter at breast height (DBH) in centimeter unit and tree height (H) in meter unit, following the allometric equations from the journal *"Allometric Equations for Estimating Above-Ground Biomass and Leaf Area of Planted Teak (Tectona grandis) Forests Under Agroforestry Management in East Java, Indonesia"* (Purwanto & Shiba, 2006). This equation has a coefficient of determination R^2 of 0.997, indicating a very high accuracy. The estimation is most reliable when used with trees from the East Java region, where the equations were derived. All measurements for DBH are in centimeter, tree height is in meter, and the output weight is in kilograms.}
\arguments{
  \item{d}{(numeric) The stem diameter at breast height (DBH) in centimeters.}
  \item{h}{(numeric) The tree height in meters.}
}
\usage{
WS(d, h)
}
\value{
The estimated stem weight (WS) in kilograms.
}
\examples{
# Example: Estimating WS using DBH = 30 cm and tree height = 15 m
d <- 30  # Stem Diameter at Breast Height in cm
h <- 15  # Tree Height in meters
WS_result <- WS(d, h)
print(WS_result)

# Example: Handling missing or zero values
d <- NA  # Stem Diameter at Breast Height in cm
h <- 15  # Tree Height in meters
WS_result <- WS(d, h)
print(WS_result)  # Should return NA because DBH is NA

d <- 0  # Stem Diameter at Breast Height in cm
h <- 15  # Tree Height in meters
WS_result <- WS(d, h)
print(WS_result)  # Should return 0 because DBH is 0
}