% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba.r
\name{padString}
\alias{padString}
\title{pad a character string to a fixed length}
\usage{
padString(
  x,
  stringLength = max(nchar(x)),
  padCharacter = " ",
  justify = "left",
  ...
)
}
\arguments{
\item{x}{\code{character} vector}

\item{stringLength}{\code{integer} length for the resulting character strings
in \code{x}. By default, all strings are padded to the length of the
longest entry, however stringLength can be defined to impose strict
number of characters for all entries.}

\item{padCharacter}{\code{character} string with nchar=1 used for padding.}

\item{justify}{\code{character} string with "left", "right", "center" to indicate
alignment of the resulting text string.}

\item{...}{additional parameters are ignored.}
}
\value{
\code{character} vector of length(x)
}
\description{
pad a character string to a fixed length
}
\examples{
padString(c("one","two","three"));
padString(c("one","two","three","four"), padCharacter="_", justify="center");

}
\seealso{
Other jam string functions: 
\code{\link{asSize}()},
\code{\link{breaksByVector}()},
\code{\link{fillBlanks}()},
\code{\link{formatInt}()},
\code{\link{gsubOrdered}()},
\code{\link{gsubs}()},
\code{\link{makeNames}()},
\code{\link{nameVector}()},
\code{\link{nameVectorN}()},
\code{\link{padInteger}()},
\code{\link{pasteByRow}()},
\code{\link{pasteByRowOrdered}()},
\code{\link{sizeAsNum}()},
\code{\link{tcount}()},
\code{\link{ucfirst}()}
}
\concept{jam string functions}
