% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-axis.R
\name{getAxisLabel}
\alias{getAxisLabel}
\title{Get axis label for minorLogTicks}
\usage{
getAxisLabel(
  i,
  asValues,
  logAxisType = c("normal", "flip", "pvalue"),
  logBase,
  base_limit = 2,
  offset = 0,
  symmetricZero = (offset > 0),
  ...
)
}
\arguments{
\item{i}{\code{numeric} axis value}

\item{asValues}{\code{logical} indicating whether the value should be
evaluated.}

\item{logAxisType}{\code{character} string with the type of axis values:
\itemize{
\item \code{"normal"}: axis values as-is.
\item \code{"flip"}: inverted axis values, for example where negative values
should be displayed as negative log-transformed values.
\item \code{"pvalue"}: for values transformed as \code{-log10(pvalue)}
}}

\item{logBase}{\code{numeric} logarithmic base}

\item{base_limit}{\code{numeric} value indicating the minimum value that
should be written as an exponential.}

\item{offset}{\code{numeric} value of offset used for log transformation.}

\item{symmetricZero}{\code{logical} indicating whether negative values
should be displayed as negative log-transformed values.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{character} or \code{expression} axis label as appropriate.
}
\description{
Get axis label for minorLogTicks
}
\details{
This function is intended to be called internally by
\code{jamba::minorLogTicks()}.
}
\examples{
x <- log10(c(1, 2, 5, 10, 20, 50, 100, 200, 500))
getAxisLabel(x, asValues=TRUE, logBase=10)

x1exp <- c(1, 2, 3, 4, 5)
plot(1:6, main="exponential values")
for (i in seq_along(x1exp)) {
   text(x=i, y=i + 0.2,
      getAxisLabel(x1exp[i], asValues=FALSE, logBase=10))
}

x1exp <- c(-3:3)
plot(-3:3, main="log2 fold change values")
for (i in seq_along(x1exp)) {
   text(x=i, y=i + 0.3 - 4,
      getAxisLabel(x1exp[i],
         logAxisType="flip",
         asValues=TRUE, logBase=2))
}

x1exp <- c(1, 2, 3, 4, 5)
plot(1:6, main="P-value style")
for (i in seq_along(x1exp)) {
   text(x=i, y=i + 0.2,
      getAxisLabel(x1exp[i],
      logAxisType="pvalue", asValues=FALSE, logBase=10))
}

}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{reload_rmarkdown_cache}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
