% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SkewJackPol.R
\name{SkewJackPol}
\alias{SkewJackPol}
\title{Skew Jack polynomial}
\usage{
SkewJackPol(n, lambda, mu, alpha, which = "J")
}
\arguments{
\item{n}{positive integer, the number of variables}

\item{lambda}{outer integer partition of the skew partition}

\item{mu}{inner integer partition of the skew partition; it must be a
subpartition of \code{lambda}}

\item{alpha}{the Jack parameter, any object coercible to a \code{bigq}
number}

\item{which}{which skew Jack polynomial, \code{"J"}, \code{"P"}, \code{"Q"}
or \code{"C"}}
}
\value{
A \code{qspray} polynomial.
}
\description{
Computes a skew Jack polynomial with a given Jack parameter.
}
\examples{
SkewJackPol(3, c(3,1), c(2), "2")
}
\seealso{
\code{\link{SkewJackSymPol}}.
}
