% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_associations.R
\name{plot_associations}
\alias{plot_associations}
\title{plot_associations
plot species-species associations}
\usage{
plot_associations(
  R,
  radius = 5,
  main = NULL,
  cex.main = NULL,
  circleBreak = FALSE,
  top = 10L,
  occ = NULL,
  env_effect = NULL,
  cols_association = c("#FF0000", "#BF003F", "#7F007F", "#3F00BF", "#0000FF"),
  cols_occurrence = c("#BEBEBE", "#8E8E8E", "#5F5F5F", "#2F2F2F", "#000000"),
  cols_env_effect = c("#1B9E77", "#D95F02", "#7570B3", "#E7298A", "#66A61E", "#E6AB02",
    "#A6761D", "#666666"),
  lwd_occurrence = 1,
  species_order = "abundance",
  species_indices = NULL
)
}
\arguments{
\item{R}{matrix of correlation \eqn{R}}

\item{radius}{circle's radius}

\item{main}{title}

\item{cex.main}{title's character size. NULL and NA are equivalent to 1.0.}

\item{circleBreak}{circle break or not}

\item{top}{number of top negative and positive associations to consider}

\item{occ}{species occurence data}

\item{env_effect}{environmental species effects \eqn{\beta}}

\item{cols_association}{color gradient for association lines}

\item{cols_occurrence}{color gradient for species}

\item{cols_env_effect}{color gradient for environmental effect}

\item{lwd_occurrence}{lwd for occurrence lines}

\item{species_order}{order species according to : \tabular{ll}{
\code{"abundance"} \tab their mean abundance at sites by default) \cr
\code{"frequency"} \tab the number of sites where they occur \cr
\code{"main environmental effect"} \tab their most important environmental coefficients \cr}}

\item{species_indices}{indices for sorting species}
}
\value{
No return value. Displays species-species associations.
}
\description{
plot_associations
plot species-species associations
}
\details{
After fitting the jSDM with latent variables, the \bold{fullspecies residual correlation matrix} : \eqn{R=(R_{ij})}{R=(R_ij)} with \eqn{i=1,\ldots, n_{species}}{i=1,..., n_species} and \eqn{j=1,\ldots, n_{species}}{j=1,..., n_species} can be derived from the covariance in the latent variables such as : 
 can be derived from the covariance in the latent variables such as : 
 \eqn{\Sigma_{ij}=\lambda_i' .\lambda_j}{Sigma_ij=\lambda_i' . \lambda_j}, in the case of a regression with probit, logit or poisson link function and 
\tabular{lll}{
\eqn{\Sigma_{ij}}{Sigma_ij} \tab \eqn{= \lambda_i' .\lambda_j + V}{= \lambda_i' . \lambda_j + V} \tab if i=j \cr
         \tab \eqn{= \lambda_i' .\lambda_j}{= \lambda_i' . \lambda_j} \tab else, \cr}
this function represents the correlations computed from covariances :
\deqn{R_{ij} = \frac{\Sigma_{ij}}{\sqrt{\Sigma_ii\Sigma _jj}}}{R_ij = Sigma_ij / sqrt(Sigma_ii.Sigma _jj)}.
}
\examples{
library(jSDM)
# frogs data
data(mites, package="jSDM")
# Arranging data
PA_mites <- mites[,1:35]
# Normalized continuous variables
Env_mites <- cbind(mites[,36:38], scale(mites[,39:40]))
colnames(Env_mites) <- colnames(mites[,36:40])
Env_mites <- as.data.frame(Env_mites)
# Parameter inference
# Increase the number of iterations to reach MCMC convergence
mod <- jSDM_poisson_log(# Response variable
                        count_data=PA_mites,
                        # Explanatory variables
                        site_formula = ~  water + topo + density,
                        site_data = Env_mites,
                        n_latent=2,
                        site_effect="random",
                        # Chains
                        burnin=100,
                        mcmc=100,
                        thin=1,
                        # Starting values
                        alpha_start=0,
                        beta_start=0,
                        lambda_start=0,
                        W_start=0,
                        V_alpha=1,
                        # Priors
                        shape=0.5, rate=0.0005,
                        mu_beta=0, V_beta=10,
                        mu_lambda=0, V_lambda=10,
                        # Various
                        seed=1234, verbose=1)
# Calcul of residual correlation between species
R <- get_residual_cor(mod)$cor.mean
plot_associations(R, circleBreak = TRUE, occ = PA_mites, species_order="abundance")
# Average of MCMC samples of species enrironmental effect beta except the intercept
env_effect <- t(sapply(mod$mcmc.sp,
                       colMeans)[grep("beta_", colnames(mod$mcmc.sp[[1]]))[-1],])
colnames(env_effect) <-  gsub("beta_", "", colnames(env_effect))
plot_associations(R, env_effect = env_effect, species_order="main env_effect")
}
\references{
Pichler M. and Hartig F. (2021) A new method for faster and more accurate inference of species associations from big community data. \cr
            \emph{Methods in Ecology and Evolution}, 12, 2159-2173 \doi{10.1111/2041-210X.13687}.
}
\seealso{
\code{\link{jSDM-package}} \code{\link{get_residual_cor}} \cr
\code{\link{jSDM_binomial_probit}} \code{\link{jSDM_binomial_probit_long_format}} \cr
\code{\link{jSDM_binomial_probit_sp_constrained}} \code{\link{jSDM_binomial_logit}}  \code{\link{jSDM_poisson_log}}
}
\author{
Ghislain Vieilledent <ghislain.vieilledent@cirad.fr>

Jeanne Clément <jeanne.clement16@laposte.net>
}
