% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mtr.R
\name{polyparse}
\alias{polyparse}
\title{Parsing marginal treatment response formulas}
\usage{
polyparse(
  formula,
  data,
  uname = "u",
  env = parent.frame(),
  as.function = FALSE
)
}
\arguments{
\item{formula}{the MTR.}

\item{data}{\code{data.frame} for which we obtain E[md | D, X, Z]
for each observation.}

\item{uname}{variable name for unobservable used in declaring the
MTR.}

\item{env}{environment, the original environment in which
the formula was declared.}

\item{as.function}{boolean, if \code{FALSE} then a list of the
polynomial terms are returned; if \code{TRUE} then a list of
functions corresponding to the polynomials are returned.}
}
\value{
A list (of lists) of monomials corresponding to the
    original MTR (for each observation); a list (of lists) of the
    integrated monomials; a vector for the degree of each of the
    original monomials in the MTR; and a vector for the names of
    each variable entering into the MTR (note \code{x^2 + x} has
    only one term, \code{x}).
}
\description{
This function takes in an MTR formula, and then parses the formula
such that it becomes a polynomial in the unobservable \code{u}. It
then breaks these polynomials into monomials, and then integrates
each of them with respect to \code{u}. Each integral corresponds to
E[md | D, X, Z].
}
\examples{
dtm <- ivmte:::gendistMosquito()

## Declare MTR functions
formula1 = ~ 1 + u
formula0 = ~ 1 + u

## Construct MTR polynomials
polynomials0 <- polyparse(formula = formula0,
                          data = dtm,
                          uname = u,
                          as.function = FALSE)

polynomials1 <- polyparse(formula = formula0,
                          data = dtm,
                          uname = u,
                          as.function = FALSE)

}
