% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rfun_itwcHochPower.R
\name{itwcHochPower}
\alias{itwcHochPower}
\title{Power for rejecting H1 using various types of the Hochberg Procedure}
\usage{
itwcHochPower(n, alpha1, alpha, deltavec, rho, proctype = "i", k = 0)
}
\arguments{
\item{n}{the sample size}

\item{alpha1}{the weighted significance levels assigned to H1}

\item{alpha}{the significance level}

\item{deltavec}{a numeric vector of two values representing the effect sizes for the two hypotheses}

\item{rho}{the correlation coefficient between two test statistics}

\item{proctype}{the improved trimmed weighted Hochberg procedure is denoted by \code{i}, the trimmed weighted Hochberg procedure is denoted by \code{t} , the weighted Hochberg procedure is denoted by \code{w}, and the conservative weighted Hochberg procedure is denoted by \code{c}}

\item{k}{a pre-specified constant in the improved trimmed weighted Hochberg procedure}
}
\value{
the power for rejecting H1 is denoted by \code{pwr1}, the power for rejecting H2 is denoted by \code{pwr2}, and the power for rejecting both H1 and H2 is denoted by \code{pwr12}
}
\description{
Power for rejecting H1 using various types of the Hochberg Procedure
}
\examples{
itwcHochPower(n = 100,
alpha1 = 0.0125, alpha = 0.025,
deltavec = c(0.2, 0.25), rho = 0.2,
proctype = "i", k = 0)
itwcHochPower(n = 100,
alpha1 = 0.0125, alpha = 0.025,
deltavec = c(0, 0), rho = 0,
proctype = "w", k = 0)
}
\references{
Gou, J., Chang, Y., Li, T., and Zhang, F. (2025). Improved trimmed weighted Hochberg procedures with two endpoints and sample size optimization. Technical Report.
}
\author{
Jiangtao Gou

Fengqing Zhang
}
