% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipad.R
\name{i_pad}
\alias{i_pad}
\title{Iterator that returns an object followed indefinitely by a fill value}
\usage{
i_pad(object, fill = NA, ...)
}
\arguments{
\item{object}{an iterable object}

\item{fill}{the value to pad the indefinite iterator after the initial
\code{object} is consumed. Default: \code{NA}}

\item{...}{Passed along to \link{iteror} constructor.}
}
\value{
iterator that returns \code{object} followed indefinitely by the
\code{fill} value
}
\description{
Constructs an iterator that returns an iterable \code{object} before padding
the iterator with the given \code{fill} value indefinitely.
}
\examples{

it <- iteror(1:9)
it_i_pad <- i_pad(it)
as.list(i_slice(it_i_pad, end=9)) # Same as as.list(1:9)

it2 <- iteror(1:9)
it2_i_pad <- i_pad(it2)
as.list(i_slice(it2_i_pad, end=10)) # Same as as.list(c(1:9, NA))

it3 <- iteror(1:9)
it3_i_pad <- i_pad(it3, fill=TRUE)
as.list(i_slice(it3_i_pad, end=10)) # Same as as.list(c(1:9, TRUE))

}
